/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog;
import org.apache.spark.sql.execution.datasources.ListingFileCatalog$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation$;
import org.apache.spark.sql.execution.streaming.FileStreamOptions;
import org.apache.spark.sql.execution.streaming.FileStreamSource$;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog;
import org.apache.spark.sql.execution.streaming.FileStreamSourceLog$;
import org.apache.spark.sql.execution.streaming.LongOffset;
import org.apache.spark.sql.execution.streaming.Offset;
import org.apache.spark.sql.execution.streaming.Source;
import org.apache.spark.sql.execution.streaming.Source$class;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\r-d\u0001B\u0001\u0003\u0001=\u0011\u0001CR5mKN#(/Z1n'>,(oY3\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\f\u001b!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\u0005%\u0011\u0011D\u0001\u0002\u0007'>,(oY3\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005}a\"a\u0002'pO\u001eLgn\u001a\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005a1\u000f]1sWN+7o]5p]B\u00111\u0005J\u0007\u0002\r%\u0011QE\u0002\u0002\r'B\f'o[*fgNLwN\u001c\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005!\u0001/\u0019;i!\tICF\u0004\u0002\u0012U%\u00111FE\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,%!A\u0001\u0007\u0001B\u0001B\u0003%\u0001&A\ngS2,gi\u001c:nCR\u001cE.Y:t\u001d\u0006lW\r\u0003\u00053\u0001\t\u0015\r\u0011\"\u00114\u0003\u0019\u00198\r[3nCV\tA\u0007\u0005\u00026q5\taG\u0003\u00028\r\u0005)A/\u001f9fg&\u0011\u0011H\u000e\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002\u000fM\u001c\u0007.Z7bA!AQ\b\u0001B\u0001B\u0003%a(\u0001\tqCJ$\u0018\u000e^5p]\u000e{G.^7ogB\u0019qh\u0012\u0015\u000f\u0005\u0001+eBA!E\u001b\u0005\u0011%BA\"\u000f\u0003\u0019a$o\\8u}%\t1#\u0003\u0002G%\u00059\u0001/Y2lC\u001e,\u0017B\u0001%J\u0005\r\u0019V-\u001d\u0006\u0003\rJA\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\r[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u00069q\u000e\u001d;j_:\u001c\b\u0003B\u0015PQ!J!\u0001\u0015\u0018\u0003\u00075\u000b\u0007\u000fC\u0003S\u0001\u0011\u00051+\u0001\u0004=S:LGO\u0010\u000b\t)V3v\u000bW-[7B\u0011q\u0003\u0001\u0005\u0006CE\u0003\rA\t\u0005\u0006OE\u0003\r\u0001\u000b\u0005\u0006aE\u0003\r\u0001\u000b\u0005\u0006eE\u0003\r\u0001\u000e\u0005\u0006{E\u0003\rA\u0010\u0005\u0006\u0017F\u0003\r\u0001\u000b\u0005\u0006\u001bF\u0003\rA\u0014\u0005\b;\u0002\u0011\r\u0011\"\u0003_\u00035\u0019x.\u001e:dK>\u0003H/[8ogV\tq\f\u0005\u0002\u0018A&\u0011\u0011M\u0001\u0002\u0012\r&dWm\u0015;sK\u0006lw\n\u001d;j_:\u001c\bBB2\u0001A\u0003%q,\u0001\bt_V\u00148-Z(qi&|gn\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006\t\u0012/^1mS\u001aLW\r\u001a\"bg\u0016\u0004\u0016\r\u001e5\u0016\u0003\u001d\u0004\"\u0001[7\u000e\u0003%T!A[6\u0002\u0005\u0019\u001c(B\u00017\u000b\u0003\u0019A\u0017\rZ8pa&\u0011a.\u001b\u0002\u0005!\u0006$\b\u000e\u0003\u0004q\u0001\u0001\u0006IaZ\u0001\u0013cV\fG.\u001b4jK\u0012\u0014\u0015m]3QCRD\u0007\u0005C\u0004s\u0001\t\u0007I\u0011B:\u00029=\u0004H/[8og^KG\u000f\u001b)beRLG/[8o\u0005\u0006\u001cX\rU1uQV\tA\u000f\u0005\u0003vu\"BS\"\u0001<\u000b\u0005]D\u0018!C5n[V$\u0018M\u00197f\u0015\tI(#\u0001\u0006d_2dWm\u0019;j_:L!\u0001\u0015<\t\rq\u0004\u0001\u0015!\u0003u\u0003uy\u0007\u000f^5p]N<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]\n\u000b7/\u001a)bi\"\u0004\u0003b\u0002@\u0001\u0005\u0004%Ia`\u0001\f[\u0016$\u0018\rZ1uC2{w-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015!AA\nGS2,7\u000b\u001e:fC6\u001cv.\u001e:dK2{w\r\u0003\u0005\u0002\n\u0001\u0001\u000b\u0011BA\u0001\u00031iW\r^1eCR\fGj\\4!\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty!\u0001\u0006nCb\u0014\u0015\r^2i\u0013\u0012,\"!!\u0005\u0011\u0007E\t\u0019\"C\u0002\u0002\u0016I\u0011A\u0001T8oO\"I\u0011\u0011\u0004\u0001A\u0002\u0013%\u00111D\u0001\u000f[\u0006D()\u0019;dQ&#w\fJ3r)\u0011\ti\"a\t\u0011\u0007E\ty\"C\u0002\u0002\"I\u0011A!\u00168ji\"Q\u0011QEA\f\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002*\u0001\u0001\u000b\u0015BA\t\u0003-i\u0017\r\u001f\"bi\u000eD\u0017\n\u001a\u0011\t\u0013\u00055\u0002A1A\u0005\n\u0005=\u0012\u0001E7bq\u001aKG.Z:QKJ\u0014\u0015\r^2i+\t\t\t\u0004E\u0003\u0012\u0003g\t9$C\u0002\u00026I\u0011aa\u00149uS>t\u0007cA\t\u0002:%\u0019\u00111\b\n\u0003\u0007%sG\u000f\u0003\u0005\u0002@\u0001\u0001\u000b\u0011BA\u0019\u0003Ei\u0017\r\u001f$jY\u0016\u001c\b+\u001a:CCR\u001c\u0007\u000e\t\u0005\n\u0003\u0007\u0002!\u0019!C\u0001\u0003\u000b\n\u0011b]3f]\u001aKG.Z:\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0005[r1aFA&\u000f\u001d\tiE\u0001E\u0001\u0003\u001f\n\u0001CR5mKN#(/Z1n'>,(oY3\u0011\u0007]\t\tF\u0002\u0004\u0002\u0005!\u0005\u00111K\n\u0004\u0003#\u0002\u0002b\u0002*\u0002R\u0011\u0005\u0011q\u000b\u000b\u0003\u0003\u001f*q!a\u0017\u0002R\u0001\t\tBA\u0005US6,7\u000f^1na\u001a9\u0011qLA)\u0001\u0006\u0005$!\u0003$jY\u0016,e\u000e\u001e:z'\u001d\ti\u0006EA2\u0003S\u00022!EA3\u0013\r\t9G\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0004#\u0005-\u0014bAA7%\t9\u0001K]8ek\u000e$\bBC\u0014\u0002^\tU\r\u0011\"\u0001\u0002rU\t\u0001\u0006\u0003\u0006\u0002v\u0005u#\u0011#Q\u0001\n!\nQ\u0001]1uQ\u0002B1\"!\u001f\u0002^\tU\r\u0011\"\u0001\u0002|\u0005IA/[7fgR\fW\u000e]\u000b\u0003\u0003{\u0002B!a \u0002Z5\u0011\u0011\u0011\u000b\u0005\f\u0003\u0007\u000biF!E!\u0002\u0013\ti(\u0001\u0006uS6,7\u000f^1na\u0002B1\"a\"\u0002^\tU\r\u0011\"\u0001\u0002\u0010\u00059!-\u0019;dQ&#\u0007bCAF\u0003;\u0012\t\u0012)A\u0005\u0003#\t\u0001BY1uG\"LE\r\t\u0005\b%\u0006uC\u0011AAH)!\t\t*a%\u0002\u0016\u0006]\u0005\u0003BA@\u0003;BaaJAG\u0001\u0004A\u0003\u0002CA=\u0003\u001b\u0003\r!! \t\u0011\u0005\u001d\u0015Q\u0012a\u0001\u0003#A!\"a'\u0002^\u0005\u0005I\u0011AAO\u0003\u0011\u0019w\u000e]=\u0015\u0011\u0005E\u0015qTAQ\u0003GC\u0001bJAM!\u0003\u0005\r\u0001\u000b\u0005\u000b\u0003s\nI\n%AA\u0002\u0005u\u0004BCAD\u00033\u0003\n\u00111\u0001\u0002\u0012!Q\u0011qUA/#\u0003%\t!!+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0016\u0016\u0004Q\u000556FAAX!\u0011\t\t,a/\u000e\u0005\u0005M&\u0002BA[\u0003o\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e&#\u0001\u0006b]:|G/\u0019;j_:LA!!0\u00024\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0015\u0005\u0005\u0017QLI\u0001\n\u0003\t\u0019-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015'\u0006BA?\u0003[C!\"!3\u0002^E\u0005I\u0011AAf\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!4+\t\u0005E\u0011Q\u0016\u0005\u000b\u0003#\fi&!A\u0005B\u0005M\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002VB!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017\u0001\u00027b]\u001eT!!a8\u0002\t)\fg/Y\u0005\u0004[\u0005e\u0007BCAs\u0003;\n\t\u0011\"\u0001\u0002h\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0007\u0005\u000b\u0003W\fi&!A\u0005\u0002\u00055\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003_\f)\u0010E\u0002\u0012\u0003cL1!a=\u0013\u0005\r\te.\u001f\u0005\u000b\u0003K\tI/!AA\u0002\u0005]\u0002BCA}\u0003;\n\t\u0011\"\u0011\u0002|\u0006y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002~B1\u0011q B\u0001\u0003_l\u0011\u0001_\u0005\u0004\u0005\u0007A(\u0001C%uKJ\fGo\u001c:\t\u0015\t\u001d\u0011QLA\u0001\n\u0003\u0011I!\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YA!\u0005\u0011\u0007E\u0011i!C\u0002\u0003\u0010I\u0011qAQ8pY\u0016\fg\u000e\u0003\u0006\u0002&\t\u0015\u0011\u0011!a\u0001\u0003_D!B!\u0006\u0002^\u0005\u0005I\u0011\tB\f\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001c\u0011)\u0011Y\"!\u0018\u0002\u0002\u0013\u0005#QD\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u001b\u0005\u000b\u0005C\ti&!A\u0005B\t\r\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003\f\t\u0015\u0002BCA\u0013\u0005?\t\t\u00111\u0001\u0002p\u001eQ!\u0011FA)\u0003\u0003E\tAa\u000b\u0002\u0013\u0019KG.Z#oiJL\b\u0003BA@\u0005[1!\"a\u0018\u0002R\u0005\u0005\t\u0012\u0001B\u0018'\u0019\u0011iC!\r\u0002dAY!1\u0007B\u001dQ\u0005u\u0014\u0011CAI\u001b\t\u0011)DC\u0002\u00038I\tqA];oi&lW-\u0003\u0003\u0003<\tU\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8og!9!K!\f\u0005\u0002\t}BC\u0001B\u0016\u0011)\u0011YB!\f\u0002\u0002\u0013\u0015#Q\u0004\u0005\u000b\u0005\u000b\u0012i#!A\u0005\u0002\n\u001d\u0013!B1qa2LH\u0003CAI\u0005\u0013\u0012YE!\u0014\t\r\u001d\u0012\u0019\u00051\u0001)\u0011!\tIHa\u0011A\u0002\u0005u\u0004\u0002CAD\u0005\u0007\u0002\r!!\u0005\t\u0015\tE#QFA\u0001\n\u0003\u0013\u0019&A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tU#Q\f\t\u0006#\u0005M\"q\u000b\t\t#\te\u0003&! \u0002\u0012%\u0019!1\f\n\u0003\rQ+\b\u000f\\34\u0011)\u0011yFa\u0014\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u0004q\u0012\u0002\u0004B\u0003B2\u0005[\t\t\u0011\"\u0003\u0003f\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u00119\u0007\u0005\u0003\u0002X\n%\u0014\u0002\u0002B6\u00033\u0014aa\u00142kK\u000e$ha\u0002B8\u0003#\u0002!\u0011\u000f\u0002\r'\u0016,gNR5mKNl\u0015\r]\n\u0004\u0005[\u0002\u0002b\u0003B;\u0005[\u0012\t\u0011)A\u0005\u0003#\t\u0001\"\\1y\u0003\u001e,Wj\u001d\u0005\b%\n5D\u0011\u0001B=)\u0011\u0011YH! \u0011\t\u0005}$Q\u000e\u0005\t\u0005k\u00129\b1\u0001\u0002\u0012!Q!\u0011\u0011B7\u0005\u0004%IAa!\u0002\u00075\f\u0007/\u0006\u0002\u0003\u0006B9!q\u0011BGQ\u0005uTB\u0001BE\u0015\u0011\u0011Y)!8\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005\u001f\u0013IIA\u0004ICNDW*\u00199\t\u0013\tM%Q\u000eQ\u0001\n\t\u0015\u0015\u0001B7ba\u0002B!Ba&\u0003n\u0001\u0007I\u0011BA>\u0003=a\u0017\r^3tiRKW.Z:uC6\u0004\bB\u0003BN\u0005[\u0002\r\u0011\"\u0003\u0003\u001e\u0006\u0019B.\u0019;fgR$\u0016.\\3ti\u0006l\u0007o\u0018\u0013fcR!\u0011Q\u0004BP\u0011)\t)C!'\u0002\u0002\u0003\u0007\u0011Q\u0010\u0005\n\u0005G\u0013i\u0007)Q\u0005\u0003{\n\u0001\u0003\\1uKN$H+[7fgR\fW\u000e\u001d\u0011\t\u0015\t\u001d&Q\u000ea\u0001\n\u0013\tY(\u0001\nmCN$\b+\u001e:hKRKW.Z:uC6\u0004\bB\u0003BV\u0005[\u0002\r\u0011\"\u0003\u0003.\u00061B.Y:u!V\u0014x-\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002\u001e\t=\u0006BCA\u0013\u0005S\u000b\t\u00111\u0001\u0002~!I!1\u0017B7A\u0003&\u0011QP\u0001\u0014Y\u0006\u001cH\u000fU;sO\u0016$\u0016.\\3ti\u0006l\u0007\u000f\t\u0005\t\u0005o\u0013i\u0007\"\u0001\u0003:\u0006\u0019\u0011\r\u001a3\u0015\r\u0005u!1\u0018B_\u0011\u00199#Q\u0017a\u0001Q!A\u0011\u0011\u0010B[\u0001\u0004\ti\b\u0003\u0005\u0003B\n5D\u0011\u0001Bb\u0003%I7OT3x\r&dW\r\u0006\u0004\u0003\f\t\u0015'q\u0019\u0005\u0007O\t}\u0006\u0019\u0001\u0015\t\u0011\u0005e$q\u0018a\u0001\u0003{B\u0001Ba3\u0003n\u0011\u0005!qC\u0001\u0006aV\u0014x-\u001a\u0005\t\u0005\u001f\u0014i\u0007\"\u0001\u0002h\u0006!1/\u001b>f\u0011!\u0011\u0019N!\u001c\u0005\u0002\tU\u0017AC1mY\u0016sGO]5fgV\u0011!q\u001b\t\u0005\u007f\u001d\u0013I\u000e\u0005\u0004\u0012\u00057D\u0013QP\u0005\u0004\u0005;\u0014\"A\u0002+va2,'\u0007\u0003\u0005\u0003b\u0002\u0001\u000b\u0011BA$\u0003)\u0019X-\u001a8GS2,7\u000f\t\u0005\b\u0005K\u0004A\u0011\u0002Bt\u000391W\r^2i\u001b\u0006DxJ\u001a4tKR$\"A!;\u0011\u0007]\u0011Y/C\u0002\u0003n\n\u0011!\u0002T8oO>3gm]3u\u0011\u001d\u0011\t\u0010\u0001C\u0001\u0005g\f!c^5uQ\n\u000bGo\u00195j]\u001edunY6fIV!!Q\u001fB~)\u0011\u00119pa\u0002\u0011\t\te(1 \u0007\u0001\t!\u0011iPa<C\u0002\t}(!\u0001+\u0012\t\r\u0005\u0011q\u001e\t\u0004#\r\r\u0011bAB\u0003%\t9aj\u001c;iS:<\u0007\"CB\u0005\u0005_$\t\u0019AB\u0006\u0003\u00111WO\\2\u0011\u000bE\u0019iAa>\n\u0007\r=!C\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\u0019\u0019\u0002\u0001C\u0001\u0007+\tQbY;se\u0016tGo\u00144gg\u0016$XC\u0001Bu\u0011\u001d\u0019I\u0002\u0001C!\u00077\t\u0001bZ3u\u0005\u0006$8\r\u001b\u000b\u0007\u0007;\u0019Id!\u0012\u0011\t\r}11\u0007\b\u0005\u0007C\u0019\tD\u0004\u0003\u0004$\r=b\u0002BB\u0013\u0007[qAaa\n\u0004,9\u0019\u0011i!\u000b\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t1e!\u0003\u0003\u00046\r]\"!\u0003#bi\u00064%/Y7f\u0015\t1e\u0001\u0003\u0005\u0004<\r]\u0001\u0019AB\u001f\u0003\u0015\u0019H/\u0019:u!\u0015\t\u00121GB !\r92\u0011I\u0005\u0004\u0007\u0007\u0012!AB(gMN,G\u000f\u0003\u0005\u0004H\r]\u0001\u0019AB \u0003\r)g\u000e\u001a\u0005\b\u0007\u0017\u0002A\u0011BB'\u000351W\r^2i\u00032dg)\u001b7fgR\u00111q\n\t\u0005\u007f\u001d\u001b\t\u0006\u0005\u0004\u0012\u00057D\u0013\u0011\u0003\u0005\b\u0007+\u0002A\u0011IB,\u0003%9W\r^(gMN,G/\u0006\u0002\u0004>!9!1\u0004\u0001\u0005B\rmC#\u0001\u0015\t\u000f\r}\u0003\u0001\"\u0011\u0004b\u000511m\\7nSR$B!!\b\u0004d!A1qIB/\u0001\u0004\u0019y\u0004C\u0004\u0004h\u0001!\te!\u001b\u0002\tM$x\u000e\u001d\u000b\u0003\u0003;\u0001")
public class FileStreamSource
implements Source,
Logging {
    private final SparkSession sparkSession;
    private final String fileFormatClassName;
    private final StructType schema;
    private final Seq<String> partitionColumns;
    private final Map<String, String> options;
    private final FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    private final Path qualifiedBasePath;
    private final Map<String, String> optionsWithPartitionBasePath;
    private final FileStreamSourceLog metadataLog;
    private long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    private final Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    private final SeenFilesMap seenFiles;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public StructType schema() {
        return this.schema;
    }

    public FileStreamOptions org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions;
    }

    private Path qualifiedBasePath() {
        return this.qualifiedBasePath;
    }

    private Map<String, String> optionsWithPartitionBasePath() {
        return this.optionsWithPartitionBasePath;
    }

    private FileStreamSourceLog metadataLog() {
        return this.metadataLog;
    }

    public long org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId;
    }

    private void org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(long x$1) {
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = x$1;
    }

    public Option<Object> org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch() {
        return this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch;
    }

    public SeenFilesMap seenFiles() {
        return this.seenFiles;
    }

    private synchronized LongOffset fetchMaxOffset() {
        Seq newFiles = (Seq)this.fetchAllFiles().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    long timestamp = tuple2._2$mcJ$sp();
                    boolean bl = this.$outer.seenFiles().isNewFile(path, timestamp);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Seq batchFiles = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().nonEmpty() ? (Seq)newFiles.take(BoxesRunTime.unboxToInt((Object)this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch().get())) : newFiles;
        batchFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(Tuple2<String, Object> file) {
                this.$outer.seenFiles().add((String)file._1(), file._2$mcJ$sp());
                this.$outer.logDebug((Function0<String>)new Serializable(this, file){
                    public static final long serialVersionUID = 0L;
                    private final Tuple2 file$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"New file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1}));
                    }
                    {
                        this.file$1 = file$1;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        int numPurged = this.seenFiles().purge();
        this.logTrace((Function0<String>)new Serializable(this, newFiles, batchFiles, numPurged){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;
            private final Seq newFiles$1;
            private final Seq batchFiles$1;
            private final int numPurged$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |Number of new files = ", "\n         |Number of files selected for batch = ", "\n         |Number of seen files = ", "\n         |Number of files purged from tracking map = ", "\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.newFiles$1.size()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size()), BoxesRunTime.boxToInteger((int)this.$outer.seenFiles().size()), BoxesRunTime.boxToInteger((int)this.numPurged$1)})))).stripMargin();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newFiles$1 = newFiles$1;
                this.batchFiles$1 = batchFiles$1;
                this.numPurged$1 = numPurged$1;
            }
        });
        if (batchFiles.nonEmpty()) {
            this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId_$eq(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId() + 1L);
            this.metadataLog().add(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId(), (FileEntry[])((TraversableOnce)batchFiles.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;

                public final FileEntry apply(Tuple2<String, Object> x0$2) {
                    Tuple2<String, Object> tuple2 = x0$2;
                    if (tuple2 != null) {
                        String path = (String)tuple2._1();
                        long timestamp = tuple2._2$mcJ$sp();
                        FileEntry fileEntry = new FileEntry(path, timestamp, this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
                        return fileEntry;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileEntry.class)));
            this.logInfo((Function0<String>)new Serializable(this, batchFiles){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileStreamSource $outer;
                private final Seq batchFiles$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Max batch id increased to ", " with ", " new files"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId()), BoxesRunTime.boxToInteger((int)this.batchFiles$1.size())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.batchFiles$1 = batchFiles$1;
                }
            });
        }
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    public synchronized <T> T withBatchingLocked(Function0<T> func) {
        return (T)func.apply();
    }

    public synchronized LongOffset currentOffset() {
        return new LongOffset(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId());
    }

    @Override
    public Dataset<Row> getBatch(Option<Offset> start, Offset end) {
        long endId;
        long startId = BoxesRunTime.unboxToLong((Object)start.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Offset x$2) {
                return ((LongOffset)x$2).offset();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return -1L;
            }
        }));
        Predef$.MODULE$.assert(startId <= (endId = ((LongOffset)end).offset()));
        FileEntry[] files = (FileEntry[])Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().get((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(startId + 1L))), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)endId)))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<FileEntry> apply(Tuple2<Object, FileEntry[]> x$3) {
                return Predef$.MODULE$.refArrayOps((Object[])x$3._2());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileEntry.class)));
        this.logInfo((Function0<String>)new Serializable(this, startId, endId, files){
            public static final long serialVersionUID = 0L;
            private final long startId$1;
            private final long endId$1;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processing ", " files from ", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$1.length), BoxesRunTime.boxToLong((long)(this.startId$1 + 1L)), BoxesRunTime.boxToLong((long)this.endId$1)}));
            }
            {
                this.startId$1 = startId$1;
                this.endId$1 = endId$1;
                this.files$1 = files$1;
            }
        });
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final FileEntry[] files$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)Predef$.MODULE$.refArrayOps((Object[])this.files$1).mkString("\n\t")).toString();
            }
            {
                this.files$1 = files$1;
            }
        });
        SparkSession x$7 = this.sparkSession;
        Seq x$8 = (Seq)Predef$.MODULE$.refArrayOps((Object[])files).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(FileEntry x$4) {
                return x$4.path();
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Some x$9 = new Some((Object)this.schema());
        Seq<String> x$10 = this.partitionColumns;
        String x$11 = this.fileFormatClassName;
        Map<String, String> x$12 = this.optionsWithPartitionBasePath();
        Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
        DataSource newDataSource = new DataSource(x$7, x$11, (Seq<String>)x$8, (Option<StructType>)x$9, x$10, x$13, x$12);
        return Dataset$.MODULE$.ofRows(this.sparkSession, (LogicalPlan)new LogicalRelation(newDataSource.resolveRelation(false), LogicalRelation$.MODULE$.apply$default$2(), LogicalRelation$.MODULE$.apply$default$3()));
    }

    private Seq<Tuple2<String, Object>> fetchAllFiles() {
        long startTime = System.nanoTime();
        Seq globbedPaths = SparkHadoopUtil$.MODULE$.get().globPathIfNecessary(this.qualifiedBasePath());
        ListingFileCatalog catalog = new ListingFileCatalog(this.sparkSession, (Seq<Path>)globbedPaths, this.options, (Option<StructType>)new Some((Object)new StructType()), ListingFileCatalog$.MODULE$.$lessinit$greater$default$5());
        Seq files = (Seq)((TraversableLike)catalog.allFiles().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(FileStatus x$5) {
                return x$5.getModificationTime();
            }
        }, (Ordering)Ordering.Long$.MODULE$)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(FileStatus status) {
                return new Tuple2((Object)status.getPath().toUri().toString(), (Object)BoxesRunTime.boxToLong((long)status.getModificationTime()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        long endTime = System.nanoTime();
        double listingTimeMs = ((double)endTime - (double)startTime) / (double)1000000;
        if (listingTimeMs > (double)2000) {
            this.logWarning((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        } else {
            this.logTrace((Function0<String>)new Serializable(this, files, listingTimeMs){
                public static final long serialVersionUID = 0L;
                private final Seq files$2;
                private final double listingTimeMs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listed ", " file(s) in ", " ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.files$2.size()), BoxesRunTime.boxToDouble((double)this.listingTimeMs$1)}));
                }
                {
                    this.files$2 = files$2;
                    this.listingTimeMs$1 = listingTimeMs$1;
                }
            });
        }
        this.logTrace((Function0<String>)new Serializable(this, files){
            public static final long serialVersionUID = 0L;
            private final Seq files$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files are:\\n\\t"})).s((Seq)Nil$.MODULE$)).append((Object)this.files$2.mkString("\n\t")).toString();
            }
            {
                this.files$2 = files$2;
            }
        });
        return files;
    }

    @Override
    public Option<Offset> getOffset() {
        return new Some((Object)this.fetchMaxOffset()).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LongOffset x$6) {
                return x$6.offset() == -1L;
            }
        });
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileStreamSource[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.qualifiedBasePath()}));
    }

    @Override
    public void commit(Offset end) {
    }

    @Override
    public void stop() {
    }

    public FileStreamSource(SparkSession sparkSession, String path, String fileFormatClassName, StructType schema, Seq<String> partitionColumns, String metadataPath, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.fileFormatClassName = fileFormatClassName;
        this.schema = schema;
        this.partitionColumns = partitionColumns;
        this.options = options;
        Source$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions = new FileStreamOptions(options);
        FileSystem fs = new Path(path).getFileSystem(sparkSession.sessionState().newHadoopConf());
        this.qualifiedBasePath = fs.makeQualified(new Path(path));
        this.optionsWithPartitionBasePath = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().optionMapWithoutPath().$plus$plus((GenTraversableOnce)(!SparkHadoopUtil$.MODULE$.get().isGlobPath(new Path(path)) && options.contains((Object)"path") ? Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"basePath"), (Object)path)})) : Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.metadataLog = new FileStreamSourceLog(FileStreamSourceLog$.MODULE$.VERSION(), sparkSession, metadataPath);
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxBatchId = BoxesRunTime.unboxToLong((Object)this.metadataLog().getLatest().map((Function1)new $anonfun$3(this)).getOrElse((Function0)new $anonfun$1(this)));
        this.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch = this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFilesPerTrigger();
        this.seenFiles = new SeenFilesMap(this.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs());
        Predef$.MODULE$.refArrayOps((Object[])this.metadataLog().allFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final void apply(FileEntry entry2) {
                this.$outer.seenFiles().add(entry2.path(), entry2.timestamp());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.seenFiles().purge();
        this.logInfo((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FileStreamSource $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"maxFilesPerBatch = ", ", maxFileAge = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$maxFilesPerBatch(), BoxesRunTime.boxToLong((long)this.$outer.org$apache$spark$sql$execution$streaming$FileStreamSource$$sourceOptions().maxFileAgeMs())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class FileEntry
    implements Serializable,
    Product {
        private final String path;
        private final long timestamp;
        private final long batchId;

        public String path() {
            return this.path;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public long batchId() {
            return this.batchId;
        }

        public FileEntry copy(String path, long timestamp, long batchId) {
            return new FileEntry(path, timestamp, batchId);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public long copy$default$3() {
            return this.batchId();
        }

        public String productPrefix() {
            return "FileEntry";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.batchId());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                case 0: {
                    object = this.path();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileEntry;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.batchId()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileEntry)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileEntry fileEntry = (FileEntry)x$1;
            String string = this.path();
            String string2 = fileEntry.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.timestamp() != fileEntry.timestamp()) return false;
            if (this.batchId() != fileEntry.batchId()) return false;
            if (!fileEntry.canEqual(this)) return false;
            return true;
        }

        public FileEntry(String path, long timestamp, long batchId) {
            this.path = path;
            this.timestamp = timestamp;
            this.batchId = batchId;
            Product.class.$init$((Product)this);
        }
    }

    public static class SeenFilesMap {
        private final long maxAgeMs;
        private final HashMap<String, Object> map;
        private long latestTimestamp;
        private long lastPurgeTimestamp;

        private HashMap<String, Object> map() {
            return this.map;
        }

        private long latestTimestamp() {
            return this.latestTimestamp;
        }

        private void latestTimestamp_$eq(long x$1) {
            this.latestTimestamp = x$1;
        }

        private long lastPurgeTimestamp() {
            return this.lastPurgeTimestamp;
        }

        private void lastPurgeTimestamp_$eq(long x$1) {
            this.lastPurgeTimestamp = x$1;
        }

        public void add(String path, long timestamp) {
            this.map().put(path, BoxesRunTime.boxToLong((long)timestamp));
            if (timestamp > this.latestTimestamp()) {
                this.latestTimestamp_$eq(timestamp);
            }
        }

        public boolean isNewFile(String path, long timestamp) {
            return timestamp >= this.lastPurgeTimestamp() && !this.map().containsKey(path);
        }

        /*
         * WARNING - void declaration
         */
        public int purge() {
            void var2_2;
            this.lastPurgeTimestamp_$eq(this.latestTimestamp() - this.maxAgeMs);
            java.util.Iterator<Map.Entry<String, Object>> iter = this.map().entrySet().iterator();
            int count2 = 0;
            while (iter.hasNext()) {
                Map.Entry<String, Object> entry2 = iter.next();
                if (BoxesRunTime.unboxToLong((Object)entry2.getValue()) >= this.lastPurgeTimestamp()) continue;
                ++count2;
                iter.remove();
            }
            return (int)var2_2;
        }

        public int size() {
            return this.map().size();
        }

        public Seq<Tuple2<String, Object>> allEntries() {
            return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.map()).asScala()).toSeq();
        }

        public SeenFilesMap(long maxAgeMs) {
            this.maxAgeMs = maxAgeMs;
            Predef$.MODULE$.require(maxAgeMs >= 0L);
            this.map = new HashMap();
            this.latestTimestamp = 0L;
            this.lastPurgeTimestamp = 0L;
        }
    }
}

