/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.util.Date;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.CreateDataSourceTableUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DescribeTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t]e\u0001B\u0001\u0003\u0001>\u0011A\u0003R3tGJL'-\u001a+bE2,7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\u0006i\u0006\u0014G.Z\u000b\u0002UA\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"Aq\u0006\u0001B\tB\u0003%!&\u0001\u0004uC\ndW\r\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u0005i\u0001/\u0019:uSRLwN\\*qK\u000e,\u0012a\r\t\u0005i]R$H\u0004\u0002 k%\u0011a\u0007I\u0001\u0007!J,G-\u001a4\n\u0005aJ$aA'ba*\u0011a\u0007\t\t\u0003imJ!\u0001P\u001d\u0003\rM#(/\u001b8h\u0011!q\u0004A!E!\u0002\u0013\u0019\u0014A\u00049beRLG/[8o'B,7\r\t\u0005\t\u0001\u0002\u0011)\u001a!C\u0001\u0003\u0006Q\u0011n]#yi\u0016tG-\u001a3\u0016\u0003\t\u0003\"aH\"\n\u0005\u0011\u0003#a\u0002\"p_2,\u0017M\u001c\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\u0006Y\u0011n]#yi\u0016tG-\u001a3!\u0011!A\u0005A!f\u0001\n\u0003\t\u0015aC5t\r>\u0014X.\u0019;uK\u0012D\u0001B\u0013\u0001\u0003\u0012\u0003\u0006IAQ\u0001\rSN4uN]7biR,G\r\t\u0005\u0006\u0019\u0002!\t!T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9{\u0005+\u0015*\u0011\u0005m\u0001\u0001\"\u0002\u0015L\u0001\u0004Q\u0003\"B\u0019L\u0001\u0004\u0019\u0004\"\u0002!L\u0001\u0004\u0011\u0005\"\u0002%L\u0001\u0004\u0011\u0005b\u0002+\u0001\u0005\u0004%\t%V\u0001\u0007_V$\b/\u001e;\u0016\u0003Y\u00032aV0c\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003=\u0002\nq\u0001]1dW\u0006<W-\u0003\u0002aC\n\u00191+Z9\u000b\u0005y\u0003\u0003CA2g\u001b\u0005!'BA3\u0017\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005\u001d$'!C!uiJL'-\u001e;f\u0011\u0019I\u0007\u0001)A\u0005-\u00069q.\u001e;qkR\u0004\u0003\"B6\u0001\t\u0003b\u0017a\u0001:v]R\u0011QN\u001d\t\u0004/~s\u0007CA8q\u001b\u00051\u0011BA9\u0007\u0005\r\u0011vn\u001e\u0005\u0006g*\u0004\r\u0001^\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003_VL!A\u001e\u0004\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000ba\u0004A\u0011B=\u0002+\u0011,7o\u0019:jE\u0016\u0004\u0016M\u001d;ji&|g.\u00138g_R!!0`A\u0005!\ty20\u0003\u0002}A\t!QK\\5u\u0011\u0015As\u000f1\u0001\u007f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001\u0017\u0003\u001d\u0019\u0017\r^1m_\u001eLA!a\u0002\u0002\u0002\ta1)\u0019;bY><G+\u00192mK\"9\u00111B<A\u0002\u00055\u0011A\u00022vM\u001a,'\u000fE\u0003\u0002\u0010\u0005ea.\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u001diW\u000f^1cY\u0016T1!a\u0006!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00037\t\tBA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bbBA\u0010\u0001\u0011%\u0011\u0011E\u0001\u001aI\u0016\u001c8M]5cK\u0016CH/\u001a8eK\u0012$\u0016M\u00197f\u0013:4w\u000eF\u0003{\u0003G\t)\u0003\u0003\u0004)\u0003;\u0001\rA \u0005\t\u0003\u0017\ti\u00021\u0001\u0002\u000e!9\u0011\u0011\u0006\u0001\u0005\n\u0005-\u0012A\u00073fg\u000e\u0014\u0018NY3G_Jl\u0017\r\u001e;fIR\u000b'\r\\3J]\u001a|G#\u0002>\u0002.\u0005=\u0002B\u0002\u0015\u0002(\u0001\u0007a\u0010\u0003\u0005\u0002\f\u0005\u001d\u0002\u0019AA\u0007\u0011\u001d\t\u0019\u0004\u0001C\u0005\u0003k\t1\u0003Z3tGJL'-Z*u_J\fw-Z%oM>$RA_A\u001c\u0003wAq!!\u000f\u00022\u0001\u0007a0\u0001\u0005nKR\fG-\u0019;b\u0011!\tY!!\rA\u0002\u00055\u0001bBA \u0001\u0011%\u0011\u0011I\u0001\u0016I\u0016\u001c8M]5cK\n+8m[3uS:<\u0017J\u001c4p)\u0015Q\u00181IA#\u0011\u001d\tI$!\u0010A\u0002yD\u0001\"a\u0003\u0002>\u0001\u0007\u0011Q\u0002\u0005\b\u0003\u0013\u0002A\u0011BA&\u0003u!Wm]2sS\n,G)\u001a;bS2,G\rU1si&$\u0018n\u001c8J]\u001a|Gc\u0002>\u0002N\u0005U\u0013q\u000b\u0005\t\u0003\u0007\t9\u00051\u0001\u0002PA\u0019q0!\u0015\n\t\u0005M\u0013\u0011\u0001\u0002\u000f'\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h\u0011\u001d\tI$a\u0012A\u0002yD\u0001\"!\u0017\u0002H\u0001\u0007\u0011QB\u0001\u0007e\u0016\u001cX\u000f\u001c;\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`\u0005)C-Z:de&\u0014W-\u0012=uK:$W\r\u001a#fi\u0006LG.\u001a3QCJ$\u0018\u000e^5p]&sgm\u001c\u000b\nu\u0006\u0005\u0014QMA4\u0003cBq!a\u0019\u0002\\\u0001\u0007!&A\buC\ndW-\u00133f]RLg-[3s\u0011\u0019A\u00131\fa\u0001}\"A\u0011\u0011NA.\u0001\u0004\tY'A\u0005qCJ$\u0018\u000e^5p]B\u0019q0!\u001c\n\t\u0005=\u0014\u0011\u0001\u0002\u0016\u0007\u0006$\u0018\r\\8h)\u0006\u0014G.\u001a)beRLG/[8o\u0011!\tY!a\u0017A\u0002\u00055\u0001bBA;\u0001\u0011%\u0011qO\u0001'I\u0016\u001c8M]5cK\u001a{'/\\1ui\u0016$G)\u001a;bS2,G\rU1si&$\u0018n\u001c8J]\u001a|G#\u0003>\u0002z\u0005m\u0014QPA@\u0011\u001d\t\u0019'a\u001dA\u0002)Ba\u0001KA:\u0001\u0004q\b\u0002CA5\u0003g\u0002\r!a\u001b\t\u0011\u0005-\u00111\u000fa\u0001\u0003\u001bAq!a!\u0001\t\u0013\t))\u0001\beKN\u001c'/\u001b2f'\u000eDW-\\1\u0015\u000bi\f9)a%\t\u0011\u0005%\u0015\u0011\u0011a\u0001\u0003\u0017\u000baa]2iK6\f\u0007\u0003B,`\u0003\u001b\u00032a`AH\u0013\u0011\t\t*!\u0001\u0003\u001b\r\u000bG/\u00197pO\u000e{G.^7o\u0011!\tY!!!A\u0002\u00055\u0001bBAB\u0001\u0011%\u0011q\u0013\u000b\u0006u\u0006e\u0015q\u0015\u0005\t\u0003\u0013\u000b)\n1\u0001\u0002\u001cB!\u0011QTAR\u001b\t\tyJC\u0002\u0002\"\u001a\tQ\u0001^=qKNLA!!*\u0002 \nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005-\u0011Q\u0013a\u0001\u0003\u001bAq!a+\u0001\t\u0013\ti+\u0001\u0004baB,g\u000e\u001a\u000b\nu\u0006=\u0016\u0011WA[\u0003sC\u0001\"a\u0003\u0002*\u0002\u0007\u0011Q\u0002\u0005\b\u0003g\u000bI\u000b1\u0001;\u0003\u0019\u0019w\u000e\\;n]\"9\u0011qWAU\u0001\u0004Q\u0014\u0001\u00033bi\u0006$\u0016\u0010]3\t\u000f\u0005m\u0016\u0011\u0016a\u0001u\u000591m\\7nK:$\b\"CA`\u0001\u0005\u0005I\u0011AAa\u0003\u0011\u0019w\u000e]=\u0015\u00139\u000b\u0019-!2\u0002H\u0006%\u0007\u0002\u0003\u0015\u0002>B\u0005\t\u0019\u0001\u0016\t\u0011E\ni\f%AA\u0002MB\u0001\u0002QA_!\u0003\u0005\rA\u0011\u0005\t\u0011\u0006u\u0006\u0013!a\u0001\u0005\"I\u0011Q\u001a\u0001\u0012\u0002\u0013\u0005\u0011qZ\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tNK\u0002+\u0003'\\#!!6\u0011\t\u0005]\u0017\u0011]\u0007\u0003\u00033TA!a7\u0002^\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?\u0004\u0013AC1o]>$\u0018\r^5p]&!\u00111]Am\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003O\u0004\u0011\u0013!C\u0001\u0003S\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002l*\u001a1'a5\t\u0013\u0005=\b!%A\u0005\u0002\u0005E\u0018AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003gT3AQAj\u0011%\t9\u0010AI\u0001\n\u0003\t\t0\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005m\b!!A\u0005B\u0005u\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0000B!!\u0011\u0001B\u0006\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011\u0001\u00027b]\u001eT!A!\u0003\u0002\t)\fg/Y\u0005\u0004y\t\r\u0001\"\u0003B\b\u0001\u0005\u0005I\u0011\u0001B\t\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\u0019\u0002E\u0002 \u0005+I1Aa\u0006!\u0005\rIe\u000e\u001e\u0005\n\u00057\u0001\u0011\u0011!C\u0001\u0005;\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003 \t\u0015\u0002cA\u0010\u0003\"%\u0019!1\u0005\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0003(\te\u0011\u0011!a\u0001\u0005'\t1\u0001\u001f\u00132\u0011%\u0011Y\u0003AA\u0001\n\u0003\u0012i#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\u0003\u0005\u0004\u00032\tM\"qD\u0007\u0003\u0003+IAA!\u000e\u0002\u0016\tA\u0011\n^3sCR|'\u000fC\u0005\u0003:\u0001\t\t\u0011\"\u0001\u0003<\u0005A1-\u00198FcV\fG\u000eF\u0002C\u0005{A!Ba\n\u00038\u0005\u0005\t\u0019\u0001B\u0010\u0011%\u0011\t\u0005AA\u0001\n\u0003\u0012\u0019%\u0001\u0004fcV\fGn\u001d\u000b\u0004\u0005\n\u0015\u0003B\u0003B\u0014\u0005\u007f\t\t\u00111\u0001\u0003 \u001dI!\u0011\n\u0002\u0002\u0002#\u0005!1J\u0001\u0015\t\u0016\u001c8M]5cKR\u000b'\r\\3D_6l\u0017M\u001c3\u0011\u0007m\u0011iE\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B('\u0015\u0011iE!\u0015%!%\u0011\u0019F!\u0017+g\t\u0013e*\u0004\u0002\u0003V)\u0019!q\u000b\u0011\u0002\u000fI,h\u000e^5nK&!!1\fB+\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\u0005\b\u0019\n5C\u0011\u0001B0)\t\u0011Y\u0005\u0003\u0006\u0003d\t5\u0013\u0011!C#\u0005K\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007fD!B!\u001b\u0003N\u0005\u0005I\u0011\u0011B6\u0003\u0015\t\u0007\u000f\u001d7z)%q%Q\u000eB8\u0005c\u0012\u0019\b\u0003\u0004)\u0005O\u0002\rA\u000b\u0005\u0007c\t\u001d\u0004\u0019A\u001a\t\r\u0001\u00139\u00071\u0001C\u0011\u0019A%q\ra\u0001\u0005\"Q!q\u000fB'\u0003\u0003%\tI!\u001f\u0002\u000fUt\u0017\r\u001d9msR!!1\u0010BD!\u0015y\"Q\u0010BA\u0013\r\u0011y\b\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000f}\u0011\u0019IK\u001aC\u0005&\u0019!Q\u0011\u0011\u0003\rQ+\b\u000f\\35\u0011%\u0011II!\u001e\u0002\u0002\u0003\u0007a*A\u0002yIAB!B!$\u0003N\u0005\u0005I\u0011\u0002BH\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tE\u0005\u0003\u0002B\u0001\u0005'KAA!&\u0003\u0004\t1qJ\u00196fGR\u0004")
public class DescribeTableCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier table;
    private final Map<String, String> partitionSpec;
    private final boolean isExtended;
    private final boolean isFormatted;
    private final Seq<Attribute> output;

    public static Function1<Tuple4<TableIdentifier, Map<String, String>, Object, Object>, DescribeTableCommand> tupled() {
        return DescribeTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Map<String, String>, Function1<Object, Function1<Object, DescribeTableCommand>>>> curried() {
        return DescribeTableCommand$.MODULE$.curried();
    }

    public final Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public Map<String, String> partitionSpec() {
        return this.partitionSpec;
    }

    public boolean isExtended() {
        return this.isExtended;
    }

    public boolean isFormatted() {
        return this.isFormatted;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        void var2_2;
        ArrayBuffer result = new ArrayBuffer();
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (catalog.isTemporaryTable(this.table())) {
            if (this.partitionSpec().nonEmpty()) {
                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESC PARTITION is not allowed on a temporary view: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            this.org$apache$spark$sql$execution$command$DescribeTableCommand$$describeSchema(catalog.lookupRelation(this.table(), catalog.lookupRelation$default$2()).schema(), (ArrayBuffer<Row>)result);
            return var2_2;
        } else {
            CatalogTable metadata = catalog.getTableMetadata(this.table());
            if (DDLUtils$.MODULE$.isDatasourceTable(metadata)) {
                Option<StructType> option = DDLUtils$.MODULE$.getSchemaFromTableProperties(metadata);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    StructType userSpecifiedSchema = (StructType)some.x();
                    this.org$apache$spark$sql$execution$command$DescribeTableCommand$$describeSchema(userSpecifiedSchema, (ArrayBuffer<Row>)result);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<StructType> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) throw new MatchError(option);
                    this.org$apache$spark$sql$execution$command$DescribeTableCommand$$describeSchema(catalog.lookupRelation(this.table(), catalog.lookupRelation$default$2()).schema(), (ArrayBuffer<Row>)result);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                this.describeSchema((Seq<CatalogColumn>)metadata.schema(), (ArrayBuffer<Row>)result);
            }
            this.describePartitionInfo(metadata, (ArrayBuffer<Row>)result);
            if (this.partitionSpec().isEmpty()) {
                if (this.isExtended()) {
                    this.describeExtendedTableInfo(metadata, (ArrayBuffer<Row>)result);
                    return var2_2;
                } else {
                    if (!this.isFormatted()) return var2_2;
                    this.describeFormattedTableInfo(metadata, (ArrayBuffer<Row>)result);
                }
                return var2_2;
            } else {
                this.describeDetailedPartitionInfo(catalog, metadata, (ArrayBuffer<Row>)result);
            }
        }
        return var2_2;
    }

    private void describePartitionInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        if (DDLUtils$.MODULE$.isDatasourceTable(table)) {
            Option<StructType> userSpecifiedSchema = DDLUtils$.MODULE$.getSchemaFromTableProperties(table);
            Seq<String> partColNames = DDLUtils$.MODULE$.getPartitionColumnsFromTableProperties(table);
            userSpecifiedSchema.withFilter((Function1)new Serializable(this, partColNames){
                public static final long serialVersionUID = 0L;
                private final Seq partColNames$1;

                public final boolean apply(StructType schema) {
                    return this.partColNames$1.nonEmpty();
                }
                {
                    this.partColNames$1 = partColNames$1;
                }
            }).foreach((Function1)new Serializable(this, buffer, partColNames){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DescribeTableCommand $outer;
                private final ArrayBuffer buffer$3;
                private final Seq partColNames$1;

                public final void apply(StructType schema) {
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$3, "# Partition Information", "", "");
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$3, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((NamedExpression)this.$outer.output().head()).name()})), ((NamedExpression)this.$outer.output().apply(1)).name(), ((NamedExpression)this.$outer.output().apply(2)).name());
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$describeSchema(StructType$.MODULE$.apply((Seq)this.partColNames$1.map((Function1)new Serializable(this, schema){
                        public static final long serialVersionUID = 0L;
                        private final StructType schema$1;

                        public final StructField apply(String x$3) {
                            return this.schema$1.apply(x$3);
                        }
                        {
                            this.schema$1 = schema$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom())), (ArrayBuffer<Row>)this.buffer$3);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.buffer$3 = buffer$3;
                    this.partColNames$1 = partColNames$1;
                }
            });
        } else if (table.partitionColumns().nonEmpty()) {
            this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "# Partition Information", "", "");
            this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"# ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((NamedExpression)this.output().head()).name()})), ((NamedExpression)this.output().apply(1)).name(), ((NamedExpression)this.output().apply(2)).name());
            this.describeSchema((Seq<CatalogColumn>)table.partitionColumns(), buffer);
        }
    }

    private void describeExtendedTableInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "# Detailed Table Information", table.toString(), "");
    }

    private void describeFormattedTableInfo(CatalogTable table, ArrayBuffer<Row> buffer) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "# Detailed Table Information", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Database:", table.database(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Owner:", table.owner(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Create Time:", new Date(table.createTime()).toString(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Last Access Time:", new Date(table.lastAccessTime()).toString(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Location:", (String)table.storage().locationUri().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Table Type:", table.tableType().name(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Table Parameters:", "", "");
        table.properties().filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    boolean bl = key.startsWith(CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA());
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$4;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$4, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value, "");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$4 = buffer$4;
            }
        });
        this.describeStorageInfo(table, buffer);
    }

    private void describeStorageInfo(CatalogTable metadata, ArrayBuffer<Row> buffer) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "# Storage Information", "", "");
        metadata.storage().serde().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$5;

            public final void apply(String serdeLib) {
                this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$5, "SerDe Library:", serdeLib, "");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$5 = buffer$5;
            }
        });
        metadata.storage().inputFormat().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$5;

            public final void apply(String format) {
                this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$5, "InputFormat:", format, "");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$5 = buffer$5;
            }
        });
        metadata.storage().outputFormat().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$5;

            public final void apply(String format) {
                this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$5, "OutputFormat:", format, "");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$5 = buffer$5;
            }
        });
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Compressed:", metadata.storage().compressed() ? "Yes" : "No", "");
        this.describeBucketingInfo(metadata, buffer);
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Storage Desc Parameters:", "", "");
        metadata.storage().serdeProperties().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$5;

            public final void apply(Tuple2<String, String> x0$3) {
                Tuple2<String, String> tuple2 = x0$3;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$5, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value, "");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$5 = buffer$5;
            }
        });
    }

    private void describeBucketingInfo(CatalogTable metadata, ArrayBuffer<Row> buffer) {
        Option<BucketSpec> option;
        block4: {
            block3: {
                block2: {
                    option = DDLUtils$.MODULE$.getBucketSpecFromTableProperties(metadata);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    BucketSpec bucketSpec = (BucketSpec)some.x();
                    this.appendBucketInfo$1(bucketSpec.numBuckets(), bucketSpec.bucketColumnNames(), bucketSpec.sortColumnNames(), buffer);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<BucketSpec> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                this.appendBucketInfo$1(metadata.numBuckets(), metadata.bucketColumnNames(), metadata.sortColumnNames(), buffer);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError(option);
    }

    private void describeDetailedPartitionInfo(SessionCatalog catalog, CatalogTable metadata, ArrayBuffer<Row> result) {
        CatalogTableType catalogTableType = metadata.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESC PARTITION is not allowed on a view: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isDatasourceTable(metadata)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DESC PARTITION is not allowed on a datasource table: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().identifier()})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CatalogTablePartition partition = catalog.getPartition(this.table(), this.partitionSpec());
        if (this.isExtended()) {
            this.describeExtendedDetailedPartitionInfo(this.table(), metadata, partition, result);
        } else if (this.isFormatted()) {
            this.describeFormattedDetailedPartitionInfo(this.table(), metadata, partition, result);
            this.describeStorageInfo(metadata, result);
        }
    }

    private void describeExtendedDetailedPartitionInfo(TableIdentifier tableIdentifier, CatalogTable table, CatalogTablePartition partition, ArrayBuffer<Row> buffer) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, new StringBuilder().append((Object)"Detailed Partition Information ").append((Object)partition.toString()).toString(), "", "");
    }

    private void describeFormattedDetailedPartitionInfo(TableIdentifier tableIdentifier, CatalogTable table, CatalogTablePartition partition, ArrayBuffer<Row> buffer) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "# Detailed Partition Information", "", "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Partition Value:", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition.spec().values().mkString(", ")})), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Database:", table.database(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Table:", tableIdentifier.table(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Location:", (String)partition.storage().locationUri().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append(buffer, "Partition Parameters:", "", "");
        partition.parameters().foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$7;

            public final void apply(Tuple2<String, String> x0$4) {
                Tuple2<String, String> tuple2 = x0$4;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    String value = (String)tuple2._2();
                    this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$7, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), value, "");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$7 = buffer$7;
            }
        });
    }

    private void describeSchema(Seq<CatalogColumn> schema, ArrayBuffer<Row> buffer) {
        schema.foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$2;

            public final void apply(CatalogColumn column) {
                this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$2, column.name(), column.dataType().toLowerCase(), (String)column.comment().orNull(Predef$.MODULE$.conforms()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$2 = buffer$2;
            }
        });
    }

    public void org$apache$spark$sql$execution$command$DescribeTableCommand$$describeSchema(StructType schema, ArrayBuffer<Row> buffer) {
        schema.foreach((Function1)new Serializable(this, buffer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DescribeTableCommand $outer;
            private final ArrayBuffer buffer$1;

            public final void apply(StructField column) {
                String comment = column.metadata().contains("comment") ? column.metadata().getString("comment") : null;
                this.$outer.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)this.buffer$1, column.name(), column.dataType().simpleString(), comment);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.buffer$1 = buffer$1;
            }
        });
    }

    public void org$apache$spark$sql$execution$command$DescribeTableCommand$$append(ArrayBuffer<Row> buffer, String column, String dataType, String comment) {
        buffer.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{column, dataType, comment})));
    }

    public DescribeTableCommand copy(TableIdentifier table, Map<String, String> partitionSpec2, boolean isExtended, boolean isFormatted) {
        return new DescribeTableCommand(table, partitionSpec2, isExtended, isFormatted);
    }

    public TableIdentifier copy$default$1() {
        return this.table();
    }

    public Map<String, String> copy$default$2() {
        return this.partitionSpec();
    }

    public boolean copy$default$3() {
        return this.isExtended();
    }

    public boolean copy$default$4() {
        return this.isFormatted();
    }

    public String productPrefix() {
        return "DescribeTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isFormatted());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isExtended());
                break;
            }
            case 1: {
                object = this.partitionSpec();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DescribeTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DescribeTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DescribeTableCommand describeTableCommand = (DescribeTableCommand)x$1;
        TableIdentifier tableIdentifier = this.table();
        TableIdentifier tableIdentifier2 = describeTableCommand.table();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Map<String, String> map2 = this.partitionSpec();
        Map<String, String> map3 = describeTableCommand.partitionSpec();
        if (map2 == null) {
            if (map3 != null) {
                return false;
            }
        } else if (!map2.equals(map3)) return false;
        if (this.isExtended() != describeTableCommand.isExtended()) return false;
        if (this.isFormatted() != describeTableCommand.isFormatted()) return false;
        if (!describeTableCommand.canEqual(this)) return false;
        return true;
    }

    private final void appendBucketInfo$1(int numBuckets, Seq bucketColumns, Seq sortColumns, ArrayBuffer buffer$6) {
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)buffer$6, "Num Buckets:", ((Object)BoxesRunTime.boxToInteger((int)numBuckets)).toString(), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)buffer$6, "Bucket Columns:", bucketColumns.mkString("[", ", ", "]"), "");
        this.org$apache$spark$sql$execution$command$DescribeTableCommand$$append((ArrayBuffer<Row>)buffer$6, "Sort Columns:", sortColumns.mkString("[", ", ", "]"), "");
    }

    public DescribeTableCommand(TableIdentifier table, Map<String, String> partitionSpec2, boolean isExtended, boolean isFormatted) {
        this.table = table;
        this.partitionSpec = partitionSpec2;
        this.isExtended = isExtended;
        this.isFormatted = isFormatted;
        Command.class.$init$((Command)this);
        AttributeReference[] attributeReferenceArray = new AttributeReference[3];
        String x$29 = "col_name";
        StringType$ x$30 = StringType$.MODULE$;
        boolean x$31 = false;
        Metadata x$32 = new MetadataBuilder().putString("comment", "name of the column").build();
        ExprId x$33 = AttributeReference$.MODULE$.apply$default$5(x$29, (DataType)x$30, x$31, x$32);
        Option x$34 = AttributeReference$.MODULE$.apply$default$6(x$29, (DataType)x$30, x$31, x$32);
        Boolean x$35 = AttributeReference$.MODULE$.apply$default$7(x$29, (DataType)x$30, x$31, x$32);
        attributeReferenceArray[0] = new AttributeReference(x$29, (DataType)x$30, x$31, x$32, x$33, x$34, x$35);
        String x$36 = "data_type";
        StringType$ x$37 = StringType$.MODULE$;
        boolean x$38 = false;
        Metadata x$39 = new MetadataBuilder().putString("comment", "data type of the column").build();
        ExprId x$40 = AttributeReference$.MODULE$.apply$default$5(x$36, (DataType)x$37, x$38, x$39);
        Option x$41 = AttributeReference$.MODULE$.apply$default$6(x$36, (DataType)x$37, x$38, x$39);
        Boolean x$42 = AttributeReference$.MODULE$.apply$default$7(x$36, (DataType)x$37, x$38, x$39);
        attributeReferenceArray[1] = new AttributeReference(x$36, (DataType)x$37, x$38, x$39, x$40, x$41, x$42);
        String x$43 = "comment";
        StringType$ x$44 = StringType$.MODULE$;
        boolean x$45 = true;
        Metadata x$46 = new MetadataBuilder().putString("comment", "comment of the column").build();
        ExprId x$47 = AttributeReference$.MODULE$.apply$default$5(x$43, (DataType)x$44, x$45, x$46);
        Option x$48 = AttributeReference$.MODULE$.apply$default$6(x$43, (DataType)x$44, x$45, x$46);
        Boolean x$49 = AttributeReference$.MODULE$.apply$default$7(x$43, (DataType)x$44, x$45, x$46);
        attributeReferenceArray[2] = new AttributeReference(x$43, (DataType)x$44, x$45, x$46, x$47, x$48, x$49);
        this.output = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])attributeReferenceArray));
    }
}

