/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.execution.command.CreateDataSourceTableUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$$anonfun$org$apache$spark$sql$execution$command$DDLUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$$anonfun$org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType$1$;
import org.apache.spark.sql.execution.datasources.BucketSpec;
import org.apache.spark.sql.types.DataType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class DDLUtils$ {
    public static final DDLUtils$ MODULE$;

    static {
        new DDLUtils$();
    }

    public boolean isDatasourceTable(Map<String, String> props) {
        return props.contains((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_PROVIDER());
    }

    public boolean isDatasourceTable(CatalogTable table) {
        return this.isDatasourceTable((Map<String, String>)table.properties());
    }

    public void verifyAlterTableType(SessionCatalog catalog, TableIdentifier tableIdentifier, boolean isView) {
        catalog.getTableMetadataOption(tableIdentifier).map((Function1)new Serializable(isView){
            public static final long serialVersionUID = 0L;
            private final boolean isView$1;

            public final void apply(CatalogTable x$13) {
                CatalogTableType catalogTableType = x$13.tableType();
                CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
                CatalogTableType catalogTableType3 = catalogTableType;
                if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.isView$1) {
                    throw new AnalysisException("Cannot alter a view with ALTER TABLE. Please use ALTER VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                CatalogTableType catalogTableType4 = catalogTableType;
                CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
                if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.isView$1) {
                    throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot alter a table with ALTER VIEW. Please use ALTER TABLE instead"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                this.isView$1 = isView$1;
            }
        });
    }

    public void verifyTableProperties(Seq<String> propKeys, String operation) {
        Seq datasourceKeys = (Seq)propKeys.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$14) {
                return x$14.startsWith(CreateDataSourceTableUtils$.MODULE$.DATASOURCE_PREFIX());
            }
        });
        if (datasourceKeys.nonEmpty()) {
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " property keys may not "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{operation}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start with '", "': ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CreateDataSourceTableUtils$.MODULE$.DATASOURCE_PREFIX(), datasourceKeys.mkString("[", ", ", "]")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public boolean isTablePartitioned(CatalogTable table) {
        return table.partitionColumns().nonEmpty() || table.properties().contains((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA_NUMPARTCOLS());
    }

    public Option<StructType> getSchemaFromTableProperties(CatalogTable metadata) {
        Predef$.MODULE$.require(this.isDatasourceTable(metadata));
        Map props = metadata.properties();
        return props.isDefinedAt((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA()) ? props.get((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructType apply(String x$15) {
                return (StructType)DataType$.MODULE$.fromJson(x$15);
            }
        }) : metadata.properties().get((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA_NUMPARTS()).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            public final CatalogTable metadata$1;

            public final StructType apply(String numParts) {
                IndexedSeq parts = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(numParts)).toInt()).map((Function1)new Serializable(this, numParts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getSchemaFromTableProperties.2 $outer;
                    private final String numParts$1;

                    /*
                     * WARNING - void declaration
                     */
                    public final String apply(int index) {
                        void var2_2;
                        String part = (String)this.$outer.metadata$1.properties().get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA_PART_PREFIX(), BoxesRunTime.boxToInteger((int)index)}))).orNull(Predef$.MODULE$.conforms());
                        if (part == null) {
                            throw new AnalysisException(new StringBuilder().append((Object)"Could not read schema from the metastore because it is corrupted ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(missing part ", " of the schema, ", " parts are expected)."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)index), this.numParts$1}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                        }
                        return var2_2;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.numParts$1 = numParts$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return (StructType)DataType$.MODULE$.fromJson(parts.mkString());
            }
            {
                this.metadata$1 = metadata$1;
            }
        });
    }

    public Seq<String> org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType(Map<String, String> props, String colType, String typeName) {
        Predef$.MODULE$.require(this.isDatasourceTable(props));
        return (Seq)Option$.MODULE$.option2Iterable(props.get((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"spark.sql.sources.schema.num", "Cols"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringOps(Predef$.MODULE$.augmentString(colType)).capitalize()})))).toSeq().flatMap((Function1)new Serializable(props, colType, typeName){
            public static final long serialVersionUID = 0L;
            public final Map props$1;
            public final String colType$1;
            public final String typeName$1;

            public final IndexedSeq<String> apply(String numCols) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new StringOps(Predef$.MODULE$.augmentString(numCols)).toInt()).map((Function1)new Serializable(this, numCols){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType$1 $outer;
                    public final String numCols$1;

                    public final String apply(int index) {
                        return (String)this.$outer.props$1.getOrElse((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "Col.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA_PREFIX(), this.$outer.colType$1, BoxesRunTime.boxToInteger((int)index)})), (Function0)new Serializable(this, index){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType$1$$anonfun$apply$8 $outer;
                            private final int index$1;

                            public final Nothing$ apply() {
                                throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupted ", " in catalog: ", " parts expected, but part ", " is missing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$sql$execution$command$DDLUtils$$anonfun$$anonfun$$$outer().typeName$1, this.$outer.numCols$1, BoxesRunTime.boxToInteger((int)this.index$1)})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.index$1 = index$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun$org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType$1 org$apache$spark$sql$execution$command$DDLUtils$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.numCols$1 = numCols$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }
            {
                this.props$1 = props$1;
                this.colType$1 = colType$1;
                this.typeName$1 = typeName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<String> getPartitionColumnsFromTableProperties(CatalogTable metadata) {
        return this.org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType((Map<String, String>)metadata.properties(), "part", "partitioning columns");
    }

    public Option<BucketSpec> getBucketSpecFromTableProperties(CatalogTable metadata) {
        return this.isDatasourceTable(metadata) ? metadata.properties().get((Object)CreateDataSourceTableUtils$.MODULE$.DATASOURCE_SCHEMA_NUMBUCKETS()).map((Function1)new Serializable(metadata){
            public static final long serialVersionUID = 0L;
            private final CatalogTable metadata$2;

            public final BucketSpec apply(String numBuckets) {
                return new BucketSpec(new StringOps(Predef$.MODULE$.augmentString(numBuckets)).toInt(), DDLUtils$.MODULE$.org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType((Map<String, String>)this.metadata$2.properties(), "bucket", "bucketing columns"), DDLUtils$.MODULE$.org$apache$spark$sql$execution$command$DDLUtils$$getColumnNamesByType((Map<String, String>)this.metadata$2.properties(), "sort", "sorting columns"));
            }
            {
                this.metadata$2 = metadata$2;
            }
        }) : None$.MODULE$;
    }

    private DDLUtils$() {
        MODULE$ = this;
    }
}

