/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$$anonfun$addPartitions$1$;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$$anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.PartitionStatistics;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenMap$;
import scala.collection.GenSeq;
import scala.collection.GenSeq$;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0001\u0003\u0001>\u0011!%\u00117uKJ$\u0016M\u00197f%\u0016\u001cwN^3s!\u0006\u0014H/\u001b;j_:\u001c8i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"\u0001\u0003'fC\u001atu\u000eZ3\u0011\u0005maR\"\u0001\u0002\n\u0005u\u0011!a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011q$J\u0005\u0003M\u0001\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u000b\u0001\u0003\u0016\u0004%\t!K\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012A\u000b\t\u0003W1j\u0011AF\u0005\u0003[Y\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\t_\u0001\u0011\t\u0012)A\u0005U\u0005QA/\u00192mK:\u000bW.\u001a\u0011\t\u0011E\u0002!Q3A\u0005\u0002I\n1aY7e+\u0005\u0019\u0004C\u0001\u001b8\u001d\tyR'\u0003\u00027A\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\rM#(/\u001b8h\u0015\t1\u0004\u0005\u0003\u0005<\u0001\tE\t\u0015!\u00034\u0003\u0011\u0019W\u000e\u001a\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ry\u0004)\u0011\t\u00037\u0001AQ\u0001\u000b\u001fA\u0002)Bq!\r\u001f\u0011\u0002\u0003\u00071\u0007C\u0004D\u0001\t\u0007I\u0011\u0001#\u0002\u00139+Vj\u0018$J\u0019\u0016\u001bV#A#\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001\u00027b]\u001eT\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u00029\u000f\"1Q\n\u0001Q\u0001\n\u0015\u000b!BT+N?\u001aKE*R*!\u0011\u001dy\u0005A1A\u0005\u0002\u0011\u000b!\u0002V(U\u00032{6+\u0013.F\u0011\u0019\t\u0006\u0001)A\u0005\u000b\u0006YAk\u0014+B\u0019~\u001b\u0016JW#!\u0011\u001d\u0019\u0006A1A\u0005\u0002\u0011\u000b\u0001\u0002\u0012#M?RKU*\u0012\u0005\u0007+\u0002\u0001\u000b\u0011B#\u0002\u0013\u0011#Ej\u0018+J\u001b\u0016\u0003\u0003\"B,\u0001\t\u0013A\u0016!D4fiB\u000bG\u000f\u001b$jYR,'\u000f\u0006\u0002ZCB\u0011!lX\u0007\u00027*\u0011A,X\u0001\u0003MNT!A\u0018\u0006\u0002\r!\fGm\\8q\u0013\t\u00017L\u0001\u0006QCRDg)\u001b7uKJDQA\u0019,A\u0002\r\f!\u0002[1e_>\u00048i\u001c8g!\t!w-D\u0001f\u0015\t1W,\u0001\u0003d_:4\u0017B\u00015f\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")!\u000e\u0001C!W\u0006\u0019!/\u001e8\u0015\u00051d\bcA7vq:\u0011an\u001d\b\u0003_Jl\u0011\u0001\u001d\u0006\u0003c:\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005Q\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003m^\u00141aU3r\u0015\t!\b\u0005\u0005\u0002zu6\ta!\u0003\u0002|\r\t\u0019!k\\<\t\u000b%I\u0007\u0019A?\u0011\u0005et\u0018BA@\u0007\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011)\t\u0019\u0001\u0001EC\u0002\u0013%\u0011QA\u0001\u0010KZ\fG\u000eV1tWN+\b\u000f]8siV\u0011\u0011q\u0001\t\u0005\u0003\u0013\t\u0019\"\u0004\u0002\u0002\f)!\u0011QBA\b\u0003!\u0001\u0018M]1mY\u0016d'bAA\tA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0014\r>\u00148NS8j]R\u000b7o[*vaB|'\u000f\u001e\u0005\u000b\u00033\u0001\u0001\u0012!Q!\n\u0005\u001d\u0011\u0001E3wC2$\u0016m]6TkB\u0004xN\u001d;!Q\u0011\t9\"!\b\u0011\u0007}\ty\"C\u0002\u0002\"\u0001\u0012\u0011\u0002\u001e:b]NLWM\u001c;\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(\u0005q1oY1o!\u0006\u0014H/\u001b;j_:\u001cH\u0003EA\u0015\u0003O\nI'!\u001d\u0002v\u0005e\u0014QPAB!\u0019\tY#!\f\u000225\u0011\u0011qB\u0005\u0005\u0003_\tyA\u0001\u0004HK:\u001cV-\u001d\t\b?\u0005M\u0012qGA1\u0013\r\t)\u0004\t\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005e\u00121\f\b\u0005\u0003w\t)F\u0004\u0003\u0002>\u0005Ec\u0002BA \u0003\u001frA!!\u0011\u0002N9!\u00111IA&\u001d\u0011\t)%!\u0013\u000f\u0007=\f9%C\u0001\u000e\u0013\tYA\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003/\u0019I1!a\u0015\u0017\u0003\u001d\u0019\u0017\r^1m_\u001eLA!a\u0016\u0002Z\u0005a1)\u0019;bY><G+\u001f9fg*\u0019\u00111\u000b\f\n\t\u0005u\u0013q\f\u0002\u0013)\u0006\u0014G.\u001a)beRLG/[8o'B,7M\u0003\u0003\u0002X\u0005e\u0003c\u0001.\u0002d%\u0019\u0011QM.\u0003\tA\u000bG\u000f\u001b\u0005\u0007\u0013\u0005\r\u0002\u0019A?\t\u000fq\u000b\u0019\u00031\u0001\u0002lA\u0019!,!\u001c\n\u0007\u0005=4L\u0001\u0006GS2,7+_:uK6Dq!a\u001d\u0002$\u0001\u0007\u0011,\u0001\u0004gS2$XM\u001d\u0005\t\u0003o\n\u0019\u00031\u0001\u0002b\u0005!\u0001/\u0019;i\u0011!\tY(a\tA\u0002\u0005]\u0012\u0001B:qK\u000eD\u0001\"a \u0002$\u0001\u0007\u0011\u0011Q\u0001\u000fa\u0006\u0014H/\u001b;j_:t\u0015-\\3t!\riWo\r\u0005\t\u0003\u000b\u000b\u0019\u00031\u0001\u0002\b\u0006IA\u000f\u001b:fg\"|G\u000e\u001a\t\u0004?\u0005%\u0015bAAFA\t\u0019\u0011J\u001c;\t\u000f\u0005=\u0005\u0001\"\u0003\u0002\u0012\u0006!r-\u0019;iKJ\u0004\u0016M\u001d;ji&|gn\u0015;biN$B\"a%\u0002 \u0006\u0005\u0016QUAT\u0003W\u0003r!a\u000b\u0002\u0016N\nI*\u0003\u0003\u0002\u0018\u0006=!AB$f]6\u000b\u0007\u000fE\u0002\u001c\u00037K1!!(\u0003\u0005M\u0001\u0016M\u001d;ji&|gn\u0015;bi&\u001cH/[2t\u0011\u0019I\u0011Q\u0012a\u0001{\"A\u00111UAG\u0001\u0004\tI#A\u000bqCJ$\u0018\u000e^5p]N\u0003XmY:B]\u0012dunY:\t\u000fq\u000bi\t1\u0001\u0002l!9\u0011\u0011VAG\u0001\u0004I\u0016A\u00039bi\"4\u0015\u000e\u001c;fe\"A\u0011QQAG\u0001\u0004\t9\tC\u0004\u00020\u0002!I!!-\u0002\u001b\u0005$G\rU1si&$\u0018n\u001c8t))\t\u0019,!/\u0002<\u0006\u001d\u0017\u0011\u001a\t\u0004?\u0005U\u0016bAA\\A\t!QK\\5u\u0011\u0019I\u0011Q\u0016a\u0001{\"A\u0011QXAW\u0001\u0004\ty,A\u0003uC\ndW\r\u0005\u0003\u0002B\u0006\rWBAA-\u0013\u0011\t)-!\u0017\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u0011\u0005\r\u0016Q\u0016a\u0001\u0003SA\u0001\"a3\u0002.\u0002\u0007\u00111S\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001cF/\u0019;t\u0011%\ty\rAA\u0001\n\u0003\t\t.\u0001\u0003d_BLH#B \u0002T\u0006U\u0007\u0002\u0003\u0015\u0002NB\u0005\t\u0019\u0001\u0016\t\u0011E\ni\r%AA\u0002MB\u0011\"!7\u0001#\u0003%\t!a7\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u001c\u0016\u0004U\u0005}7FAAq!\u0011\t\u0019/!<\u000e\u0005\u0005\u0015(\u0002BAt\u0003S\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-\b%\u0001\u0006b]:|G/\u0019;j_:LA!a<\u0002f\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005M\b!%A\u0005\u0002\u0005U\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003oT3aMAp\u0011!\tY\u0010AA\u0001\n\u0003\"\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u0007\u0010C\u0005\u0002\u0000\u0002\t\t\u0011\"\u0001\u0003\u0002\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0011\u0005\n\u0005\u000b\u0001\u0011\u0011!C\u0001\u0005\u000f\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\n\t=\u0001cA\u0010\u0003\f%\u0019!Q\u0002\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0003\u0012\t\r\u0011\u0011!a\u0001\u0003\u000f\u000b1\u0001\u001f\u00132\u0011%\u0011)\u0002AA\u0001\n\u0003\u00129\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011I\u0002\u0005\u0004\u0002,\tm!\u0011B\u0005\u0005\u0005;\tyA\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\u0011\t\u0003AA\u0001\n\u0003\u0011\u0019#\u0001\u0005dC:,\u0015/^1m)\u0011\u0011)Ca\u000b\u0011\u0007}\u00119#C\u0002\u0003*\u0001\u0012qAQ8pY\u0016\fg\u000e\u0003\u0006\u0003\u0012\t}\u0011\u0011!a\u0001\u0005\u0013A\u0011Ba\f\u0001\u0003\u0003%\tE!\r\u0002\r\u0015\fX/\u00197t)\u0011\u0011)Ca\r\t\u0015\tE!QFA\u0001\u0002\u0004\u0011IaB\u0005\u00038\t\t\t\u0011#\u0001\u0003:\u0005\u0011\u0013\t\u001c;feR\u000b'\r\\3SK\u000e|g/\u001a:QCJ$\u0018\u000e^5p]N\u001cu.\\7b]\u0012\u00042a\u0007B\u001e\r!\t!!!A\t\u0002\tu2#\u0002B\u001e\u0005\u007f!\u0003c\u0002B!\u0005\u000fR3gP\u0007\u0003\u0005\u0007R1A!\u0012!\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\u0013\u0003D\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\t\u000fu\u0012Y\u0004\"\u0001\u0003NQ\u0011!\u0011\b\u0005\u000b\u0005#\u0012Y$!A\u0005F\tM\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0015C!Ba\u0016\u0003<\u0005\u0005I\u0011\u0011B-\u0003\u0015\t\u0007\u000f\u001d7z)\u0015y$1\fB/\u0011\u0019A#Q\u000ba\u0001U!A\u0011G!\u0016\u0011\u0002\u0003\u00071\u0007\u0003\u0006\u0003b\tm\u0012\u0011!CA\u0005G\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003f\t5\u0004#B\u0010\u0003h\t-\u0014b\u0001B5A\t1q\n\u001d;j_:\u0004RaHA\u001aUMB\u0011Ba\u001c\u0003`\u0005\u0005\t\u0019A \u0002\u0007a$\u0003\u0007\u0003\u0006\u0003t\tm\u0012\u0013!C\u0001\u0003k\fq\"\u00199qYf$C-\u001a4bk2$HE\r\u0005\u000b\u0005o\u0012Y$%A\u0005\u0002\u0005U\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#\u0007\u0003\u0006\u0003|\tm\u0012\u0011!C\u0005\u0005{\n1B]3bIJ+7o\u001c7wKR\u0011!q\u0010\t\u0004\r\n\u0005\u0015b\u0001BB\u000f\n1qJ\u00196fGR\u0004")
public class AlterTableRecoverPartitionsCommand
extends LeafNode
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final String cmd;
    private final String NUM_FILES;
    private final String TOTAL_SIZE;
    private final String DDL_TIME;
    private transient ForkJoinTaskSupport evalTaskSupport;
    private volatile transient boolean bitmap$trans$0;

    public static String $lessinit$greater$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.$lessinit$greater$default$2();
    }

    public static String apply$default$2() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<TableIdentifier, String>, AlterTableRecoverPartitionsCommand> tupled() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, AlterTableRecoverPartitionsCommand>> curried() {
        return AlterTableRecoverPartitionsCommand$.MODULE$.curried();
    }

    private ForkJoinTaskSupport evalTaskSupport$lzycompute() {
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = this;
        synchronized (alterTableRecoverPartitionsCommand) {
            if (!this.bitmap$trans$0) {
                this.evalTaskSupport = new ForkJoinTaskSupport(new ForkJoinPool(8));
                this.bitmap$trans$0 = true;
            }
            return this.evalTaskSupport;
        }
    }

    public final Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String cmd() {
        return this.cmd;
    }

    public String NUM_FILES() {
        return this.NUM_FILES;
    }

    public String TOTAL_SIZE() {
        return this.TOTAL_SIZE;
    }

    public String DDL_TIME() {
        return this.DDL_TIME;
    }

    public PathFilter org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(Configuration hadoopConf) {
        JobConf jobConf = new JobConf(hadoopConf, this.getClass());
        PathFilter pathFilter = FileInputFormat.getInputPathFilter((JobConf)jobConf);
        return new PathFilter(this, pathFilter){
            private final PathFilter pathFilter$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean accept(Path path) {
                String name;
                String string = name = path.getName();
                String string2 = "_SUCCESS";
                if (string == null) {
                    if (string2 == null) return false;
                } else if (string.equals(string2)) return false;
                String string3 = name;
                String string4 = "_temporary";
                if (string3 == null) {
                    if (string4 == null) return false;
                } else if (string3.equals(string4)) return false;
                if (name.startsWith(".")) {
                    return false;
                }
                if (this.pathFilter$1 == null) return true;
                if (!this.pathFilter$1.accept(path)) return false;
                return true;
            }
            {
                this.pathFilter$1 = pathFilter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<Row> run(SparkSession spark) {
        void var4_4;
        SessionCatalog catalog = spark.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        String tableIdentWithDB = table.identifier().quotedString();
        if (DDLUtils$.MODULE$.isDatasourceTable(table)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " on datasource tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd(), tableIdentWithDB})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (DDLUtils$.MODULE$.isTablePartitioned(table)) {
            if (table.storage().locationUri().isEmpty()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on table with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"location provided: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableIdentWithDB}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            Path root = new Path((String)table.storage().locationUri().get());
            this.logInfo((Function0)new Serializable(this, root){
                public static final long serialVersionUID = 0L;
                private final Path root$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recover all the partitions in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.root$1}));
                }
                {
                    this.root$1 = root$1;
                }
            });
            FileSystem fs = root.getFileSystem(spark.sparkContext().hadoopConfiguration());
            int threshold = new StringOps(Predef$.MODULE$.augmentString(spark.conf().get("spark.rdd.parallelListingThreshold", "10"))).toInt();
            Configuration hadoopConf = spark.sparkContext().hadoopConfiguration();
            PathFilter pathFilter = this.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(hadoopConf);
            GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs = this.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(spark, fs, pathFilter, root, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)), (Seq<String>)((Seq)table.partitionColumnNames().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$8) {
                    return x$8.toLowerCase();
                }
            }, Seq$.MODULE$.canBuildFrom())), threshold);
            int total = partitionSpecsAndLocs.length();
            this.logInfo((Function0)new Serializable(this, root, total){
                public static final long serialVersionUID = 0L;
                private final Path root$1;
                private final int total$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " partitions in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1), this.root$1}));
                }
                {
                    this.root$1 = root$1;
                    this.total$1 = total$1;
                }
            });
            GenMap<String, PartitionStatistics> partitionStats = spark.sqlContext().conf().gatherFastStats() ? this.gatherPartitionStats(spark, partitionSpecsAndLocs, fs, pathFilter, threshold) : GenMap$.MODULE$.empty();
            this.logInfo((Function0)new Serializable(this, total){
                public static final long serialVersionUID = 0L;
                private final int total$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Finished to gather the fast stats for all ", " partitions."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1)}));
                }
                {
                    this.total$1 = total$1;
                }
            });
            this.addPartitions(spark, table, partitionSpecsAndLocs, partitionStats);
            this.logInfo((Function0)new Serializable(this, total){
                public static final long serialVersionUID = 0L;
                private final int total$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered all partitions (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total$1)}));
                }
                {
                    this.total$1 = total$1;
                }
            });
            return (Seq)Seq$.MODULE$.empty();
        }
        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", " only works on partitioned tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cmd(), var4_4})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    private ForkJoinTaskSupport evalTaskSupport() {
        return this.bitmap$trans$0 ? this.evalTaskSupport : this.evalTaskSupport$lzycompute();
    }

    public GenSeq<Tuple2<Map<String, String>, Path>> org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(SparkSession spark, FileSystem fs, PathFilter filter2, Path path, Map<String, String> spec, Seq<String> partitionNames, int threshold) {
        WrappedArray wrappedArray;
        if (partitionNames.isEmpty()) {
            return (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(spec), (Object)path)}));
        }
        FileStatus[] statuses = fs.listStatus(path, filter2);
        if (partitionNames.length() > 1 && statuses.length > threshold || partitionNames.length() > 2) {
            ParArray parArray = Predef$.MODULE$.refArrayOps((Object[])statuses).par();
            parArray.tasksupport_$eq((TaskSupport)this.evalTaskSupport());
            wrappedArray = parArray;
        } else {
            wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])statuses);
        }
        WrappedArray statusPar = wrappedArray;
        return (GenSeq)statusPar.flatMap((Function1)new Serializable(this, spark, fs, filter2, path, spec, partitionNames, threshold){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
            private final SparkSession spark$1;
            private final FileSystem fs$1;
            private final PathFilter filter$1;
            public final Path path$1;
            private final Map spec$1;
            public final Seq partitionNames$1;
            private final int threshold$1;

            public final GenSeq<Tuple2<Map<String, String>, Path>> apply(FileStatus st) {
                GenSeq<Tuple2<Map<String, String>, Path>> genSeq;
                String name = st.getPath().getName();
                if (st.isDirectory() && name.contains("=")) {
                    String[] ps = name.split("=", 2);
                    String columnName = PartitioningUtils$.MODULE$.unescapePathName(ps[0]).toLowerCase();
                    String value = PartitioningUtils$.MODULE$.unescapePathName(ps[1]);
                    String string = columnName;
                    Object object = this.partitionNames$1.head();
                    if (!(string != null ? !string.equals(object) : object != null)) {
                        genSeq = this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions(this.spark$1, this.fs$1, this.filter$1, st.getPath(), (Map<String, String>)this.spec$1.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)columnName), (Object)value)}))), (Seq<String>)((Seq)this.partitionNames$1.drop(1)), this.threshold$1);
                    } else {
                        this.$outer.logWarning((Function0)new Serializable(this, ps){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions$1 $outer;
                            private final String[] ps$1;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect partition column ", ", but got ", ", ignore it"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.partitionNames$1.head(), this.ps$1[0]}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.ps$1 = ps$1;
                            }
                        });
                        genSeq = (GenSeq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                } else {
                    this.$outer.logWarning((Function0)new Serializable(this, name){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$scanPartitions$1 $outer;
                        private final String name$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ignore ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new Path(this.$outer.path$1, this.name$1)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.name$1 = name$1;
                        }
                    });
                    genSeq = (GenSeq<Tuple2<Map<String, String>, Path>>)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                }
                return genSeq;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.spark$1 = spark$1;
                this.fs$1 = fs$1;
                this.filter$1 = filter$1;
                this.path$1 = path$1;
                this.spec$1 = spec$1;
                this.partitionNames$1 = partitionNames$1;
                this.threshold$1 = threshold$1;
            }
        }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom());
    }

    private GenMap<String, PartitionStatistics> gatherPartitionStats(SparkSession spark, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, FileSystem fs, PathFilter pathFilter, int threshold) {
        GenMap genMap;
        if (partitionSpecsAndLocs.length() > threshold) {
            Configuration hadoopConf = spark.sparkContext().hadoopConfiguration();
            SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
            String[] serializedPaths = (String[])((GenTraversableOnce)partitionSpecsAndLocs.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<Map<String, String>, Path> x$9) {
                    return ((Path)x$9._2()).toString();
                }
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
            int numParallelism = Math.min(serializedPaths.length, Math.min(spark.sparkContext().defaultParallelism(), 10000));
            this.logInfo((Function0)new Serializable(this, numParallelism){
                public static final long serialVersionUID = 0L;
                private final int numParallelism$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Gather the fast stats in parallel using ", " tasks."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numParallelism$1)}));
                }
                {
                    this.numParallelism$1 = numParallelism$1;
                }
            });
            RDD qual$1 = spark.sparkContext().parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])serializedPaths), numParallelism, ClassTag$.MODULE$.apply(String.class));
            Serializable x$81 = new Serializable(this, serializableConfiguration){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
                public final SerializableConfiguration serializableConfiguration$1;

                public final Iterator<Tuple2<String, PartitionStatistics>> apply(Iterator<String> paths) {
                    PathFilter pathFilter = this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$getPathFilter(this.serializableConfiguration$1.value());
                    return paths.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x$10) {
                            return new Path(x$10);
                        }
                    }).map((Function1)new Serializable(this, pathFilter){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$10 $outer;
                        private final PathFilter pathFilter$3;

                        public final Tuple2<String, PartitionStatistics> apply(Path path) {
                            FileSystem fs = path.getFileSystem(this.$outer.serializableConfiguration$1.value());
                            FileStatus[] statuses = fs.listStatus(path, this.pathFilter$3);
                            return new Tuple2((Object)path.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(FileStatus x$11) {
                                    return x$11.getLen();
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.pathFilter$3 = pathFilter$3;
                        }
                    });
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.serializableConfiguration$1 = serializableConfiguration$1;
                }
            };
            boolean x$82 = qual$1.mapPartitions$default$2();
            genMap = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.mapPartitions((Function1)x$81, x$82, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PartitionStatistics.class), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        } else {
            genMap = ((GenTraversableOnce)partitionSpecsAndLocs.map((Function1)new Serializable(this, fs, pathFilter){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$2;
                private final PathFilter pathFilter$2;

                public final Tuple2<String, PartitionStatistics> apply(Tuple2<Map<String, String>, Path> x0$3) {
                    Tuple2<Map<String, String>, Path> tuple2 = x0$3;
                    if (tuple2 != null) {
                        Path location = (Path)tuple2._2();
                        FileStatus[] statuses = this.fs$2.listStatus(location, this.pathFilter$2);
                        Tuple2 tuple22 = new Tuple2((Object)location.toString(), (Object)new PartitionStatistics(statuses.length, BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps((long[])Predef$.MODULE$.refArrayOps((Object[])statuses).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(FileStatus x$12) {
                                return x$12.getLen();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$))));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.fs$2 = fs$2;
                    this.pathFilter$2 = pathFilter$2;
                }
            }, (CanBuildFrom)GenSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        }
        return genMap;
    }

    private void addPartitions(SparkSession spark, CatalogTable table, GenSeq<Tuple2<Map<String, String>, Path>> partitionSpecsAndLocs, GenMap<String, PartitionStatistics> partitionStats) {
        int total = partitionSpecsAndLocs.length();
        LongRef done = new LongRef(0L);
        int batchSize = 100;
        partitionSpecsAndLocs.toIterator().grouped(batchSize).foreach((Function1)new Serializable(this, spark, table, partitionStats, total, done){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlterTableRecoverPartitionsCommand $outer;
            private final SparkSession spark$2;
            public final CatalogTable table$4;
            public final GenMap partitionStats$1;
            public final int total$2;
            public final LongRef done$1;

            public final void apply(Seq<Tuple2<Map<String, String>, Path>> batch) {
                long now = System.currentTimeMillis() / 1000L;
                Seq parts = (Seq)batch.map((Function1)new Serializable(this, now){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    public final long now$1;

                    public final CatalogTablePartition apply(Tuple2<Map<String, String>, Path> x0$4) {
                        Tuple2<Map<String, String>, Path> tuple2 = x0$4;
                        if (tuple2 != null) {
                            Map spec = (Map)tuple2._1();
                            Path location = (Path)tuple2._2();
                            Map params = (Map)this.$outer.partitionStats$1.get((Object)location.toString()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$addPartitions$1$$anonfun$11 $outer;

                                public final Map<String, String> apply(PartitionStatistics x0$5) {
                                    PartitionStatistics partitionStatistics = x0$5;
                                    if (partitionStatistics != null) {
                                        int numFiles = partitionStatistics.numFiles();
                                        long totalSize = partitionStatistics.totalSize();
                                        Map map2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().NUM_FILES()), (Object)((Object)BoxesRunTime.boxToInteger((int)numFiles)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().TOTAL_SIZE()), (Object)((Object)BoxesRunTime.boxToLong((long)totalSize)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer().org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer().DDL_TIME()), (Object)((Object)BoxesRunTime.boxToLong((long)this.$outer.now$1)).toString())}));
                                        return map2;
                                    }
                                    throw new MatchError((Object)partitionStatistics);
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }).getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Map<String, Nothing$> apply() {
                                    return Predef$.MODULE$.Map().empty();
                                }
                            });
                            CatalogTablePartition catalogTablePartition = new CatalogTablePartition(spec, this.$outer.table$4.storage().copy((Option)new Some((Object)location.toUri().toString()), this.$outer.table$4.storage().copy$default$2(), this.$outer.table$4.storage().copy$default$3(), this.$outer.table$4.storage().copy$default$4(), this.$outer.table$4.storage().copy$default$5(), this.$outer.table$4.storage().copy$default$6()), params);
                            return catalogTablePartition;
                        }
                        throw new MatchError(tuple2);
                    }

                    public /* synthetic */ $anonfun$addPartitions$1 org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.now$1 = now$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
                this.spark$2.sessionState().catalog().createPartitions(this.$outer.tableName(), parts, true);
                this.done$1.elem += (long)parts.length();
                this.$outer.logDebug((Function0)new Serializable(this, parts){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$addPartitions$1 $outer;
                    private final Seq parts$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Recovered ", " partitions (", "/", " so far)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.parts$1.length()), BoxesRunTime.boxToLong((long)this.$outer.done$1.elem), BoxesRunTime.boxToInteger((int)this.$outer.total$2)}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.parts$1 = parts$1;
                    }
                });
            }

            public /* synthetic */ AlterTableRecoverPartitionsCommand org$apache$spark$sql$execution$command$AlterTableRecoverPartitionsCommand$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.spark$2 = spark$2;
                this.table$4 = table$4;
                this.partitionStats$1 = partitionStats$1;
                this.total$2 = total$2;
                this.done$1 = done$1;
            }
        });
    }

    public AlterTableRecoverPartitionsCommand copy(TableIdentifier tableName, String cmd) {
        return new AlterTableRecoverPartitionsCommand(tableName, cmd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.cmd();
    }

    public String productPrefix() {
        return "AlterTableRecoverPartitionsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                string = this.cmd();
                break;
            }
            case 0: {
                string = this.tableName();
            }
        }
        return string;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableRecoverPartitionsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableRecoverPartitionsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableRecoverPartitionsCommand alterTableRecoverPartitionsCommand = (AlterTableRecoverPartitionsCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableRecoverPartitionsCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.cmd();
        String string2 = alterTableRecoverPartitionsCommand.cmd();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableRecoverPartitionsCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableRecoverPartitionsCommand(TableIdentifier tableName, String cmd) {
        this.tableName = tableName;
        this.cmd = cmd;
        Command.class.$init$((Command)this);
        this.NUM_FILES = "numFiles";
        this.TOTAL_SIZE = "totalSize";
        this.DDL_TIME = "transient_lastDdlTime";
    }
}

