/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.set;

import java.nio.IntBuffer;
import java.util.Arrays;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.list.DoubleArrayList;
import org.apache.mahout.math.set.AbstractSet;
import org.apache.mahout.math.set.HashUtils;

public abstract class AbstractDoubleSet
extends AbstractSet {
    public boolean contains(final double key) {
        return !this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double iterKey) {
                return key != iterKey;
            }
        });
    }

    public AbstractDoubleSet copy() {
        return (AbstractDoubleSet)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractDoubleSet)) {
            return false;
        }
        final AbstractDoubleSet other = (AbstractDoubleSet)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double key) {
                return other.contains(key);
            }
        });
    }

    public int hashCode() {
        final int[] buf = new int[this.size()];
        this.forEachKey(new DoubleProcedure(){
            int i = 0;

            @Override
            public boolean apply(double iterKey) {
                buf[this.i++] = HashUtils.hash(iterKey);
                return true;
            }
        });
        Arrays.sort(buf);
        return IntBuffer.wrap(buf).hashCode();
    }

    public abstract boolean forEachKey(DoubleProcedure var1);

    public DoubleArrayList keys() {
        DoubleArrayList list = new DoubleArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final DoubleArrayList list) {
        list.clear();
        this.forEachKey(new DoubleProcedure(){

            @Override
            public boolean apply(double key) {
                list.add(key);
                return true;
            }
        });
    }

    public abstract boolean add(double var1);

    public abstract boolean remove(double var1);

    public String toString() {
        DoubleArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            double key = theKeys.get(i);
            buf.append(String.valueOf(key));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }
}

