/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import org.apache.mahout.math.function.DoubleDoubleFunction;

public final class PlusMult
extends DoubleDoubleFunction {
    private double multiplicator;

    public PlusMult(double multiplicator) {
        this.multiplicator = multiplicator;
    }

    @Override
    public double apply(double a, double b) {
        return a + b * this.multiplicator;
    }

    public static PlusMult minusMult(double constant) {
        return new PlusMult(-constant);
    }

    public static PlusMult plusMult(double constant) {
        return new PlusMult(constant);
    }

    public double getMultiplicator() {
        return this.multiplicator;
    }

    @Override
    public boolean isLikeRightPlus() {
        return true;
    }

    @Override
    public boolean isLikeLeftMult() {
        return false;
    }

    @Override
    public boolean isLikeRightMult() {
        return false;
    }

    @Override
    public boolean isCommutative() {
        return Math.abs(this.multiplicator - 1.0) < 1.0E-6;
    }

    @Override
    public boolean isAssociative() {
        return Math.abs(this.multiplicator - 0.0) < 1.0E-6 || Math.abs(this.multiplicator - 1.0) < 1.0E-6;
    }

    public void setMultiplicator(double multiplicator) {
        this.multiplicator = multiplicator;
    }
}

