/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.set.OpenIntHashSet;

public abstract class VectorBinaryAggregate {
    public static final VectorBinaryAggregate[] OPERATIONS = new VectorBinaryAggregate[]{new AggregateNonzerosIterateThisLookupThat(), new AggregateNonzerosIterateThatLookupThis(), new AggregateIterateIntersection(), new AggregateIterateUnionSequential(), new AggregateIterateUnionRandom(), new AggregateAllIterateSequential(), new AggregateAllIterateThisLookupThat(), new AggregateAllIterateThatLookupThis(), new AggregateAllLoop()};

    public abstract boolean isValid(Vector var1, Vector var2, DoubleDoubleFunction var3, DoubleDoubleFunction var4);

    public abstract double estimateCost(Vector var1, Vector var2, DoubleDoubleFunction var3, DoubleDoubleFunction var4);

    public abstract double aggregate(Vector var1, Vector var2, DoubleDoubleFunction var3, DoubleDoubleFunction var4);

    public static VectorBinaryAggregate getBestOperation(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
        int bestOperationIndex = -1;
        double bestCost = Double.POSITIVE_INFINITY;
        for (int i = 0; i < OPERATIONS.length; ++i) {
            double cost;
            if (!OPERATIONS[i].isValid(x, y, fa, fc) || !((cost = OPERATIONS[i].estimateCost(x, y, fa, fc)) < bestCost)) continue;
            bestCost = cost;
            bestOperationIndex = i;
        }
        return OPERATIONS[bestOperationIndex];
    }

    public static double aggregateBest(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
        return VectorBinaryAggregate.getBestOperation(x, y, fa, fc).aggregate(x, y, fa, fc);
    }

    public static class AggregateAllLoop
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return true;
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (double)x.size() * x.getLookupCost() * y.getLookupCost();
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            double result = fc.apply(x.getQuick(0), y.getQuick(0));
            for (int i = 1; i < x.size(); ++i) {
                result = fa.apply(result, fc.apply(x.getQuick(i), y.getQuick(i)));
            }
            return result;
        }
    }

    public static class AggregateAllIterateThatLookupThis
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (fa.isAssociativeAndCommutative() || y.isSequentialAccess()) && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (double)y.size() * y.getIteratorAdvanceCost() * x.getLookupCost();
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> yi = y.all().iterator();
            boolean validResult = false;
            double result = 0.0;
            while (yi.hasNext()) {
                Vector.Element ye = yi.next();
                double thisResult = fc.apply(x.getQuick(ye.index()), ye.get());
                if (validResult) {
                    result = fa.apply(result, thisResult);
                    continue;
                }
                result = thisResult;
                validResult = true;
            }
            return result;
        }
    }

    public static class AggregateAllIterateThisLookupThat
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (fa.isAssociativeAndCommutative() || x.isSequentialAccess()) && !x.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (double)x.size() * x.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> xi = x.all().iterator();
            boolean validResult = false;
            double result = 0.0;
            while (xi.hasNext()) {
                Vector.Element xe = xi.next();
                double thisResult = fc.apply(xe.get(), y.getQuick(xe.index()));
                if (validResult) {
                    result = fa.apply(result, thisResult);
                    continue;
                }
                result = thisResult;
                validResult = true;
            }
            return result;
        }
    }

    public static class AggregateAllIterateSequential
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return x.isSequentialAccess() && y.isSequentialAccess() && !x.isDense() && !y.isDense();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return Math.max((double)x.size() * x.getIteratorAdvanceCost(), (double)y.size() * y.getIteratorAdvanceCost());
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> xi = x.all().iterator();
            Iterator<Vector.Element> yi = y.all().iterator();
            boolean validResult = false;
            double result = 0.0;
            while (xi.hasNext() && yi.hasNext()) {
                Vector.Element xe = xi.next();
                double thisResult = fc.apply(xe.get(), yi.next().get());
                if (validResult) {
                    result = fa.apply(result, thisResult);
                    continue;
                }
                result = thisResult;
                validResult = true;
            }
            return result;
        }
    }

    public static class AggregateIterateUnionRandom
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return fa.isLikeRightPlus() && !fc.isDensifying() && (fa.isAssociativeAndCommutative() || x.isSequentialAccess() && y.isSequentialAccess());
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost() * y.getLookupCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * x.getLookupCost());
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            double thisResult;
            OpenIntHashSet visited = new OpenIntHashSet();
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            boolean validResult = false;
            double result = 0.0;
            while (xi.hasNext()) {
                Vector.Element xe = xi.next();
                thisResult = fc.apply(xe.get(), y.getQuick(xe.index()));
                if (validResult) {
                    result = fa.apply(result, thisResult);
                } else {
                    result = thisResult;
                    validResult = true;
                }
                visited.add(xe.index());
            }
            for (Vector.Element ye : y.nonZeroes()) {
                if (visited.contains(ye.index())) continue;
                thisResult = fc.apply(x.getQuick(ye.index()), ye.get());
                if (validResult) {
                    result = fa.apply(result, thisResult);
                    continue;
                }
                result = thisResult;
                validResult = true;
            }
            return result;
        }
    }

    public static class AggregateIterateUnionSequential
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return fa.isLikeRightPlus() && !fc.isDensifying() && x.isSequentialAccess() && y.isSequentialAccess();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return Math.max((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost());
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            Vector.Element xe = null;
            Vector.Element ye = null;
            boolean advanceThis = true;
            boolean advanceThat = true;
            boolean validResult = false;
            double result = 0.0;
            while (true) {
                double thisResult;
                if (advanceThis) {
                    xe = xi.hasNext() ? xi.next() : null;
                }
                if (advanceThat) {
                    ye = yi.hasNext() ? yi.next() : null;
                }
                if (xe != null && ye != null) {
                    if (xe.index() == ye.index()) {
                        thisResult = fc.apply(xe.get(), ye.get());
                        advanceThis = true;
                        advanceThat = true;
                    } else if (xe.index() < ye.index()) {
                        thisResult = fc.apply(xe.get(), 0.0);
                        advanceThis = true;
                        advanceThat = false;
                    } else {
                        thisResult = fc.apply(0.0, ye.get());
                        advanceThis = false;
                        advanceThat = true;
                    }
                } else if (xe != null) {
                    thisResult = fc.apply(xe.get(), 0.0);
                    advanceThis = true;
                    advanceThat = false;
                } else {
                    if (ye == null) break;
                    thisResult = fc.apply(0.0, ye.get());
                    advanceThis = false;
                    advanceThat = true;
                }
                if (validResult) {
                    result = fa.apply(result, thisResult);
                    continue;
                }
                result = thisResult;
                validResult = true;
            }
            return result;
        }
    }

    public static class AggregateIterateIntersection
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return fa.isLikeRightPlus() && fc.isLikeMult() && x.isSequentialAccess() && y.isSequentialAccess();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return Math.min((double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost(), (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost());
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            Vector.Element xe = null;
            Vector.Element ye = null;
            boolean advanceThis = true;
            boolean advanceThat = true;
            boolean validResult = false;
            double result = 0.0;
            while (true) {
                if (advanceThis) {
                    if (!xi.hasNext()) break;
                    xe = xi.next();
                }
                if (advanceThat) {
                    if (!yi.hasNext()) break;
                    ye = yi.next();
                }
                if (xe.index() == ye.index()) {
                    double thisResult = fc.apply(xe.get(), ye.get());
                    if (validResult) {
                        result = fa.apply(result, thisResult);
                    } else {
                        result = thisResult;
                        validResult = true;
                    }
                    advanceThis = true;
                    advanceThat = true;
                    continue;
                }
                if (xe.index() < ye.index()) {
                    advanceThis = true;
                    advanceThat = false;
                    continue;
                }
                advanceThis = false;
                advanceThat = true;
            }
            return result;
        }
    }

    public static class AggregateNonzerosIterateThatLookupThis
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return fa.isLikeRightPlus() && (fa.isAssociativeAndCommutative() || y.isSequentialAccess()) && fc.isLikeRightMult();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (double)y.getNumNondefaultElements() * y.getIteratorAdvanceCost() * x.getLookupCost() * x.getLookupCost();
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> yi = y.nonZeroes().iterator();
            if (!yi.hasNext()) {
                return 0.0;
            }
            Vector.Element ye = yi.next();
            double result = fc.apply(x.getQuick(ye.index()), ye.get());
            while (yi.hasNext()) {
                ye = yi.next();
                result = fa.apply(result, fc.apply(x.getQuick(ye.index()), ye.get()));
            }
            return result;
        }
    }

    public static class AggregateNonzerosIterateThisLookupThat
    extends VectorBinaryAggregate {
        @Override
        public boolean isValid(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return fa.isLikeRightPlus() && (fa.isAssociativeAndCommutative() || x.isSequentialAccess()) && fc.isLikeLeftMult();
        }

        @Override
        public double estimateCost(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            return (double)x.getNumNondefaultElements() * x.getIteratorAdvanceCost() * y.getLookupCost();
        }

        @Override
        public double aggregate(Vector x, Vector y, DoubleDoubleFunction fa, DoubleDoubleFunction fc) {
            Iterator<Vector.Element> xi = x.nonZeroes().iterator();
            if (!xi.hasNext()) {
                return 0.0;
            }
            Vector.Element xe = xi.next();
            double result = fc.apply(xe.get(), y.getQuick(xe.index()));
            while (xi.hasNext()) {
                xe = xi.next();
                result = fa.apply(result, fc.apply(xe.get(), y.getQuick(xe.index())));
            }
            return result;
        }
    }
}

