/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.FunctionalMatrixView;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MurmurHash;
import org.apache.mahout.math.SparseColumnMatrix;
import org.apache.mahout.math.TransposedMatrixView;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.IntIntFunction;

public final class Matrices {
    private static final double UNIFORM_DIVISOR = Math.pow(2.0, 64.0);

    public static final Matrix functionalMatrixView(int rows, int columns, IntIntFunction gf, boolean denseLike) {
        return new FunctionalMatrixView(rows, columns, gf, denseLike);
    }

    public static final Matrix functionalMatrixView(int rows, int columns, IntIntFunction gf) {
        return new FunctionalMatrixView(rows, columns, gf);
    }

    public static final Matrix transposedView(Matrix m) {
        Preconditions.checkArgument((!(m instanceof SparseColumnMatrix) ? 1 : 0) != 0);
        if (m instanceof TransposedMatrixView) {
            return ((TransposedMatrixView)m).getDelegate();
        }
        return new TransposedMatrixView(m);
    }

    public static final Matrix gaussianView(int rows, int columns, long seed) {
        return Matrices.functionalMatrixView(rows, columns, Matrices.gaussianGenerator(seed), true);
    }

    public static final Matrix symmetricUniformView(int rows, int columns, int seed) {
        return Matrices.functionalMatrixView(rows, columns, Matrices.uniformSymmetricGenerator(seed), true);
    }

    public static final Matrix uniformView(int rows, int columns, int seed) {
        return Matrices.functionalMatrixView(rows, columns, Matrices.uniformGenerator(seed), true);
    }

    public static final IntIntFunction gaussianGenerator(final long seed) {
        final Random rnd = RandomUtils.getRandom(seed);
        IntIntFunction gaussianGF = new IntIntFunction(){

            @Override
            public double apply(int first, int second) {
                rnd.setSeed(seed ^ ((long)first << 32 | (long)second & 0xFFFFFFFFL));
                return rnd.nextGaussian();
            }
        };
        return gaussianGF;
    }

    public static final IntIntFunction uniformSymmetricGenerator(final int seed) {
        return new IntIntFunction(){
            private byte[] data = new byte[8];

            @Override
            public double apply(int row, int column) {
                long d = (long)row << 32 | (long)column & 0xFFFFFFFFL;
                int i = 0;
                while (i < 8) {
                    this.data[i] = (byte)d;
                    ++i;
                    d >>>= 8;
                }
                long hash = MurmurHash.hash64A(this.data, seed);
                return (double)hash / UNIFORM_DIVISOR;
            }
        };
    }

    public static final IntIntFunction uniformGenerator(int seed) {
        return Functions.chain(new DoubleFunction(){

            @Override
            public double apply(double x) {
                return (x + 1.0) / 2.0;
            }
        }, Matrices.uniformSymmetricGenerator(seed));
    }
}

