/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.parser;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.Origin;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

public final class ParserUtils$ {
    public static final ParserUtils$ MODULE$;

    static {
        new ParserUtils$();
    }

    public String command(ParserRuleContext ctx) {
        return this.command(ctx.getStart().getInputStream());
    }

    public String command(CharStream stream) {
        return stream.getText(Interval.of((int)0, (int)stream.size()));
    }

    public Nothing$ operationNotAllowed(String message, ParserRuleContext ctx) {
        throw new ParseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Operation not allowed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})), ctx);
    }

    public <T> void checkDuplicateKeys(Seq<Tuple2<String, T>> keyPairs, ParserRuleContext ctx) {
        ((IterableLike)keyPairs.groupBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, T> x$1) {
                return (String)x$1._1();
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Seq<Tuple2<String, T>>> x$2) {
                return ((SeqLike)x$2._2()).size() > 1;
            }
        })).foreach((Function1)new Serializable(ctx){
            public static final long serialVersionUID = 0L;
            private final ParserRuleContext ctx$1;

            public final Nothing$ apply(Tuple2<String, Seq<Tuple2<String, T>>> x0$1) {
                Tuple2<String, Seq<Tuple2<String, T>>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    throw new ParseException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found duplicate keys '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), this.ctx$1);
                }
                throw new MatchError(tuple2);
            }
            {
                this.ctx$1 = ctx$1;
            }
        });
    }

    public String source(ParserRuleContext ctx) {
        CharStream stream = ctx.getStart().getInputStream();
        return stream.getText(Interval.of((int)ctx.getStart().getStartIndex(), (int)ctx.getStop().getStopIndex()));
    }

    public String remainder(ParserRuleContext ctx) {
        return this.remainder(ctx.getStop());
    }

    public String remainder(Token token) {
        CharStream stream = token.getInputStream();
        Interval interval = Interval.of((int)(token.getStopIndex() + 1), (int)stream.size());
        return stream.getText(interval);
    }

    public String string(Token token) {
        return this.unescapeSQLString(token.getText());
    }

    public String string(TerminalNode node2) {
        return this.unescapeSQLString(node2.getText());
    }

    public Origin position(Token token) {
        return new Origin((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)token.getLine())), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)token.getCharPositionInLine())));
    }

    public void validate(Function0<Object> f, String message, ParserRuleContext ctx) {
        if (f.apply$mcZ$sp()) {
            return;
        }
        throw new ParseException(message, ctx);
    }

    public <T> T withOrigin(ParserRuleContext ctx, Function0<T> f) {
        Origin current = CurrentOrigin$.MODULE$.get();
        CurrentOrigin$.MODULE$.set(this.position(ctx.getStart()));
        try {
            return (T)f.apply();
        }
        finally {
            CurrentOrigin$.MODULE$.set(current);
        }
    }

    public String unescapeSQLString(String b) {
        Character enclosure = null;
        StringBuilder sb = new StringBuilder(b.length());
        int strLength = b.length();
        for (int i = 0; i < strLength; ++i) {
            BoxedUnit boxedUnit;
            char currentChar = b.charAt(i);
            if (enclosure == null) {
                if (currentChar == '\'' || currentChar == '\"') {
                    enclosure = Predef$.MODULE$.char2Character(currentChar);
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (BoxesRunTime.equals(enclosure, (Object)BoxesRunTime.boxToCharacter((char)currentChar))) {
                enclosure = null;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (currentChar == '\\') {
                if (i + 6 < strLength && b.charAt(i + 1) == 'u') {
                    int base = i + 2;
                    int code = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(b, base){
                        public static final long serialVersionUID = 0L;
                        private final String b$1;
                        private final int base$1;

                        public final int apply(int mid, int j) {
                            return this.apply$mcIII$sp(mid, j);
                        }

                        public int apply$mcIII$sp(int mid, int j) {
                            int digit = Character.digit(this.b$1.charAt(j + this.base$1), 16);
                            return (mid << 4) + digit;
                        }
                        {
                            this.b$1 = b$1;
                            this.base$1 = base$1;
                        }
                    }));
                    sb.append((char)code);
                    i += 5;
                } else if (i + 4 < strLength) {
                    char i1 = b.charAt(i + 1);
                    char i2 = b.charAt(i + 2);
                    char i3 = b.charAt(i + 3);
                    if (i1 >= '0' && i1 <= '1' && i2 >= '0' && i2 <= '7' && i3 >= '0' && i3 <= '7') {
                        char tmp = (char)(i3 - 48 + (i2 - 48 << 3) + (i1 - 48 << 6));
                        sb.append(tmp);
                        i += 3;
                    } else {
                        this.appendEscapedChar$1(i1, sb);
                        ++i;
                    }
                } else if (i + 2 < strLength) {
                    char n = b.charAt(i + 1);
                    this.appendEscapedChar$1(n, sb);
                    ++i;
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = sb.append(currentChar);
        }
        return sb.toString();
    }

    public LogicalPlan EnhancedLogicalPlan(LogicalPlan plan2) {
        return plan2;
    }

    private final void appendEscapedChar$1(char n, StringBuilder sb$1) {
        char c = n;
        switch (c) {
            default: {
                sb$1.append(n);
                break;
            }
            case '_': {
                sb$1.append("\\_");
                break;
            }
            case '%': {
                sb$1.append("\\%");
                break;
            }
            case '\\': {
                sb$1.append('\\');
                break;
            }
            case 'Z': {
                sb$1.append('\u001a');
                break;
            }
            case 't': {
                sb$1.append('\t');
                break;
            }
            case 'r': {
                sb$1.append('\r');
                break;
            }
            case 'n': {
                sb$1.append('\n');
                break;
            }
            case 'b': {
                sb$1.append('\b');
                break;
            }
            case '\"': {
                sb$1.append('\"');
                break;
            }
            case '\'': {
                sb$1.append('\'');
                break;
            }
            case '0': {
                sb$1.append('\u0000');
            }
        }
    }

    private ParserUtils$() {
        MODULE$ = this;
    }
}

