/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.catalog;

import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.CatalystConf;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.FunctionIdentifier$;
import org.apache.spark.sql.catalyst.SimpleCatalystConf;
import org.apache.spark.sql.catalyst.SimpleCatalystConf$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.analysis.FunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchPermanentFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTempFunctionException;
import org.apache.spark.sql.catalyst.analysis.SimpleFunctionRegistry;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempFunctionAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.TempTableAlreadyExistsException;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn;
import org.apache.spark.sql.catalyst.catalog.CatalogColumn$;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.DummyFunctionResourceLoader$;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog$;
import org.apache.spark.sql.catalyst.catalog.SimpleCatalogRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.catalyst.util.StringUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0011}s!B\u0001\u0003\u0011\u0003y\u0011AD*fgNLwN\\\"bi\u0006dwn\u001a\u0006\u0003\u0007\u0011\tqaY1uC2|wM\u0003\u0002\u0006\r\u0005A1-\u0019;bYf\u001cHO\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051C\u0001\bTKN\u001c\u0018n\u001c8DCR\fGn\\4\u0014\u0005E!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\rC\u0003\u001c#\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001f!9a$\u0005b\u0001\n\u0003y\u0012\u0001\u0005#F\r\u0006+F\nV0E\u0003R\u000b%)Q*F+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007'R\u0014\u0018N\\4\t\r%\n\u0002\u0015!\u0003!\u0003E!UIR!V\u0019R{F)\u0011+B\u0005\u0006\u001bV\t\t\u0004\u0005%\t\u00011fE\u0002+)1\u0002\"!\f\u0019\u000e\u00039R!a\f\u0005\u0002\u0011%tG/\u001a:oC2L!!\r\u0018\u0003\u000f1{wmZ5oO\"A1G\u000bB\u0001B\u0003%A'A\bfqR,'O\\1m\u0007\u0006$\u0018\r\\8h!\t\u0001R'\u0003\u00027\u0005\tyQ\t\u001f;fe:\fGnQ1uC2|w\r\u0003\u00059U\t\u0005\t\u0015!\u0003:\u0003Y1WO\\2uS>t'+Z:pkJ\u001cW\rT8bI\u0016\u0014\bC\u0001\t;\u0013\tY$A\u0001\fGk:\u001cG/[8o%\u0016\u001cx.\u001e:dK2{\u0017\rZ3s\u0011!i$F!A!\u0002\u0013q\u0014\u0001\u00054v]\u000e$\u0018n\u001c8SK\u001eL7\u000f\u001e:z!\ty$)D\u0001A\u0015\t\tE!\u0001\u0005b]\u0006d\u0017p]5t\u0013\t\u0019\u0005I\u0001\tGk:\u001cG/[8o%\u0016<\u0017n\u001d;ss\"AQI\u000bB\u0001B\u0003%a)\u0001\u0003d_:4\u0007CA$I\u001b\u0005!\u0011BA%\u0005\u00051\u0019\u0015\r^1msN$8i\u001c8g\u0011!Y%F!A!\u0002\u0013a\u0015A\u00035bI>|\u0007oQ8oMB\u0011Q*U\u0007\u0002\u001d*\u0011Qi\u0014\u0006\u0003!*\ta\u0001[1e_>\u0004\u0018B\u0001*O\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")1D\u000bC\u0001)R1QKV,Y3j\u0003\"\u0001\u0005\u0016\t\u000bM\u001a\u0006\u0019\u0001\u001b\t\u000ba\u001a\u0006\u0019A\u001d\t\u000bu\u001a\u0006\u0019\u0001 \t\u000b\u0015\u001b\u0006\u0019\u0001$\t\u000b-\u001b\u0006\u0019\u0001'\t\u000bmQC\u0011\u0001/\u0015\tUkfl\u0018\u0005\u0006gm\u0003\r\u0001\u000e\u0005\u0006{m\u0003\rA\u0010\u0005\u0006\u000bn\u0003\rA\u0012\u0005\u00067)\"\t!\u0019\u000b\u0003+\nDQa\r1A\u0002QBq\u0001\u001a\u0016C\u0002\u0013EQ-\u0001\u0006uK6\u0004H+\u00192mKN,\u0012A\u001a\t\u0005O2tG/D\u0001i\u0015\tI'.A\u0004nkR\f'\r\\3\u000b\u0005-4\u0012AC2pY2,7\r^5p]&\u0011Q\u000e\u001b\u0002\b\u0011\u0006\u001c\b.T1q!\ty'O\u0004\u0002\u0016a&\u0011\u0011OF\u0001\u0007!J,G-\u001a4\n\u0005\u001d\u001a(BA9\u0017!\t)(0D\u0001w\u0015\t9\b0A\u0004m_\u001eL7-\u00197\u000b\u0005e$\u0011!\u00029mC:\u001c\u0018BA>w\u0005-aunZ5dC2\u0004F.\u00198\t\ruT\u0003\u0015!\u0003g\u0003-!X-\u001c9UC\ndWm\u001d\u0011)\rq|\u00181CA\u000b!\u0011\t\t!a\u0004\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t!bY8oGV\u0014(/\u001a8u\u0015\u0011\tI!a\u0003\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0002\u000e\u0005)!.\u0019<bq&!\u0011\u0011CA\u0002\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0002\u0018\u0005!A\u000f[5t\u0011%\tYB\u000ba\u0001\n#\ti\"A\u0005dkJ\u0014XM\u001c;EEV\ta\u000eC\u0005\u0002\")\u0002\r\u0011\"\u0005\u0002$\u0005i1-\u001e:sK:$HIY0%KF$B!!\n\u0002,A\u0019Q#a\n\n\u0007\u0005%bC\u0001\u0003V]&$\b\"CA\u0017\u0003?\t\t\u00111\u0001o\u0003\rAH%\r\u0005\b\u0003cQ\u0003\u0015)\u0003o\u0003)\u0019WO\u001d:f]R$%\r\t\u0015\b\u0003_y\u00181CA\u000b\u0011!\t9D\u000bQ\u0005\u0012\u0005e\u0012a\u00044pe6\fG\u000fV1cY\u0016t\u0015-\\3\u0015\u00079\fY\u0004C\u0004\u0002>\u0005U\u0002\u0019\u00018\u0002\t9\fW.\u001a\u0005\t\u0003\u0003R\u0003\u0015\"\u0005\u0002D\u0005\u0011bm\u001c:nCR$\u0015\r^1cCN,g*Y7f)\rq\u0017Q\t\u0005\b\u0003{\ty\u00041\u0001o\u0011\u001d\tIE\u000bC\u0005\u0003\u0017\n\u0011#\\1lKF+\u0018\r\\5gS\u0016$\u0007+\u0019;i)\u0011\ti%!\u0017\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015P\u0003\t17/\u0003\u0003\u0002X\u0005E#\u0001\u0002)bi\"Dq!a\u0017\u0002H\u0001\u0007a.\u0001\u0003qCRD\u0007bBA0U\u0011%\u0011\u0011M\u0001\u0010e\u0016\fX/\u001b:f\t\n,\u00050[:ugR!\u0011QEA2\u0011\u001d\t)'!\u0018A\u00029\f!\u0001\u001a2\t\u000f\u0005%$\u0006\"\u0003\u0002l\u0005\u0011\"/Z9vSJ,G+\u00192mK\u0016C\u0018n\u001d;t)\u0011\t)#!\u001c\t\u0011\u0005u\u0012q\ra\u0001\u0003_\u00022aRA9\u0013\r\t\u0019\b\u0002\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\"9\u0011q\u000f\u0016\u0005\n\u0005e\u0014!\u0006:fcVL'/\u001a+bE2,gj\u001c;Fq&\u001cHo\u001d\u000b\u0005\u0003K\tY\b\u0003\u0005\u0002>\u0005U\u0004\u0019AA8\u0011\u001d\tyH\u000bC\u0001\u0003\u0003\u000bab\u0019:fCR,G)\u0019;bE\u0006\u001cX\r\u0006\u0004\u0002&\u0005\r\u0015Q\u0012\u0005\t\u0003\u000b\u000bi\b1\u0001\u0002\b\u0006aAM\u0019#fM&t\u0017\u000e^5p]B\u0019\u0001#!#\n\u0007\u0005-%AA\bDCR\fGn\\4ECR\f'-Y:f\u0011!\ty)! A\u0002\u0005E\u0015AD5h]>\u0014X-\u00134Fq&\u001cHo\u001d\t\u0004+\u0005M\u0015bAAK-\t9!i\\8mK\u0006t\u0007bBAMU\u0011\u0005\u00111T\u0001\rIJ|\u0007\u000fR1uC\n\f7/\u001a\u000b\t\u0003K\ti*a(\u0002$\"9\u0011QMAL\u0001\u0004q\u0007\u0002CAQ\u0003/\u0003\r!!%\u0002#%<gn\u001c:f\u0013\u001atu\u000e^#ySN$8\u000f\u0003\u0005\u0002&\u0006]\u0005\u0019AAI\u0003\u001d\u0019\u0017m]2bI\u0016Dq!!++\t\u0003\tY+A\u0007bYR,'\u000fR1uC\n\f7/\u001a\u000b\u0005\u0003K\ti\u000b\u0003\u0005\u0002\u0006\u0006\u001d\u0006\u0019AAD\u0011\u001d\t\tL\u000bC\u0001\u0003g\u000b1cZ3u\t\u0006$\u0018MY1tK6+G/\u00193bi\u0006$B!a\"\u00026\"9\u0011QMAX\u0001\u0004q\u0007bBA]U\u0011\u0005\u00111X\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\t\t*!0\t\u000f\u0005\u0015\u0014q\u0017a\u0001]\"9\u0011\u0011\u0019\u0016\u0005\u0002\u0005\r\u0017!\u00047jgR$\u0015\r^1cCN,7\u000f\u0006\u0002\u0002FB)\u0011qYAl]:!\u0011\u0011ZAj\u001d\u0011\tY-!5\u000e\u0005\u00055'bAAh\u001d\u00051AH]8pizJ\u0011aF\u0005\u0004\u0003+4\u0012a\u00029bG.\fw-Z\u0005\u0005\u00033\fYNA\u0002TKFT1!!6\u0017\u0011\u001d\t\tM\u000bC\u0001\u0003?$B!!2\u0002b\"9\u00111]Ao\u0001\u0004q\u0017a\u00029biR,'O\u001c\u0005\b\u0003OTC\u0011AA\u000f\u0003I9W\r^\"veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\t\u000f\u0005-(\u0006\"\u0001\u0002n\u0006\u00112/\u001a;DkJ\u0014XM\u001c;ECR\f'-Y:f)\u0011\t)#a<\t\u000f\u0005\u0015\u0014\u0011\u001ea\u0001]\"9\u00111\u001f\u0016\u0005\u0002\u0005U\u0018\u0001E4fi\u0012+g-Y;mi\u0012\u0013\u0005+\u0019;i)\rq\u0017q\u001f\u0005\b\u0003K\n\t\u00101\u0001o\u0011\u001d\tYP\u000bC\u0001\u0003{\f1b\u0019:fCR,G+\u00192mKR1\u0011QEA\u0000\u0005\u0013A\u0001B!\u0001\u0002z\u0002\u0007!1A\u0001\u0010i\u0006\u0014G.\u001a#fM&t\u0017\u000e^5p]B\u0019\u0001C!\u0002\n\u0007\t\u001d!A\u0001\u0007DCR\fGn\\4UC\ndW\r\u0003\u0005\u0002\u0010\u0006e\b\u0019AAI\u0011\u001d\u0011iA\u000bC\u0001\u0005\u001f\t!\"\u00197uKJ$\u0016M\u00197f)\u0011\t)C!\u0005\t\u0011\t\u0005!1\u0002a\u0001\u0005\u0007AqA!\u0006+\t\u0003\u00119\"A\u0006uC\ndW-\u0012=jgR\u001cH\u0003BAI\u00053A\u0001\"!\u0010\u0003\u0014\u0001\u0007\u0011q\u000e\u0005\b\u0005;QC\u0011\u0001B\u0010\u0003A9W\r\u001e+bE2,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003\u0004\t\u0005\u0002\u0002CA\u001f\u00057\u0001\r!a\u001c\t\u000f\t\u0015\"\u0006\"\u0001\u0003(\u00051r-\u001a;UC\ndW-T3uC\u0012\fG/Y(qi&|g\u000e\u0006\u0003\u0003*\t=\u0002#B\u000b\u0003,\t\r\u0011b\u0001B\u0017-\t1q\n\u001d;j_:D\u0001\"!\u0010\u0003$\u0001\u0007\u0011q\u000e\u0005\b\u0005gQC\u0011\u0001B\u001b\u0003%aw.\u00193UC\ndW\r\u0006\u0006\u0002&\t]\"\u0011\bB\u001f\u0005\u0003B\u0001\"!\u0010\u00032\u0001\u0007\u0011q\u000e\u0005\b\u0005w\u0011\t\u00041\u0001o\u0003!aw.\u00193QCRD\u0007\u0002\u0003B \u0005c\u0001\r!!%\u0002\u0017%\u001cxJ^3soJLG/\u001a\u0005\t\u0005\u0007\u0012\t\u00041\u0001\u0002\u0012\u0006Y\u0001n\u001c7e\t\u0012cE+[7f\u0011\u001d\u00119E\u000bC\u0001\u0005\u0013\nQ\u0002\\8bIB\u000b'\u000f^5uS>tG\u0003EA\u0013\u0005\u0017\u0012iEa\u0014\u0003b\t\r$Q\rB5\u0011!\tiD!\u0012A\u0002\u0005=\u0004b\u0002B\u001e\u0005\u000b\u0002\rA\u001c\u0005\t\u0005#\u0012)\u00051\u0001\u0003T\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0005+\u0012YFD\u0002\u0011\u0005/J1A!\u0017\u0003\u00031\u0019\u0015\r^1m_\u001e$\u0016\u0010]3t\u0013\u0011\u0011iFa\u0018\u0003%Q\u000b'\r\\3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0006\u0004\u00053\u0012\u0001\u0002\u0003B \u0005\u000b\u0002\r!!%\t\u0011\t\r#Q\ta\u0001\u0003#C\u0001Ba\u001a\u0003F\u0001\u0007\u0011\u0011S\u0001\u0012S:DWM]5u)\u0006\u0014G.Z*qK\u000e\u001c\b\u0002\u0003B6\u0005\u000b\u0002\r!!%\u0002+%\u001c8k[3xK\u0012\u001cFo\u001c:f\u0003N\u001cVO\u00193je\"9!q\u000e\u0016\u0005\u0002\tE\u0014\u0001\u00053fM\u0006,H\u000e\u001e+bE2,\u0007+\u0019;i)\rq'1\u000f\u0005\t\u0005k\u0012i\u00071\u0001\u0002p\u0005QA/\u00192mK&#WM\u001c;\t\u000f\te$\u0006\"\u0001\u0003|\u0005q1M]3bi\u0016$V-\u001c9WS\u0016<H\u0003CA\u0013\u0005{\u0012yH!!\t\u000f\u0005u\"q\u000fa\u0001]\"9!\u0011\u0001B<\u0001\u0004!\b\u0002\u0003BB\u0005o\u0002\r!!%\u0002!=4XM\u001d:jI\u0016Le-\u0012=jgR\u001c\bb\u0002BDU\u0011\u0005!\u0011R\u0001\fO\u0016$H+Z7q-&,w\u000f\u0006\u0003\u0003\f\n5\u0005\u0003B\u000b\u0003,QDq!!\u0010\u0003\u0006\u0002\u0007a\u000eC\u0004\u0003\u0012*\"\tAa%\u0002\u0019\u0011\u0014x\u000e\u001d+f[B4\u0016.Z<\u0015\t\u0005\u0015\"Q\u0013\u0005\b\u0003{\u0011y\t1\u0001o\u0011\u001d\u0011IJ\u000bC\u0001\u00057\u000b1eZ3u)\u0016l\u0007OV5fo>\u0013\b+\u001a:nC:,g\u000e\u001e+bE2,W*\u001a;bI\u0006$\u0018\r\u0006\u0003\u0003\u0004\tu\u0005\u0002CA\u001f\u0005/\u0003\r!a\u001c\t\u000f\t\u0005&\u0006\"\u0001\u0003$\u0006Y!/\u001a8b[\u0016$\u0016M\u00197f)\u0019\t)C!*\u0003*\"A!q\u0015BP\u0001\u0004\ty'A\u0004pY\u0012t\u0015-\\3\t\u0011\t-&q\u0014a\u0001\u0003_\nqA\\3x\u001d\u0006lW\rC\u0004\u00030*\"\tA!-\u0002\u0013\u0011\u0014x\u000e\u001d+bE2,GCBA\u0013\u0005g\u0013)\f\u0003\u0005\u0002>\t5\u0006\u0019AA8\u0011!\t\tK!,A\u0002\u0005E\u0005b\u0002B]U\u0011\u0005!1X\u0001\u000fY>|7.\u001e9SK2\fG/[8o)\u0015!(Q\u0018B`\u0011!\tiDa.A\u0002\u0005=\u0004B\u0003Ba\u0005o\u0003\n\u00111\u0001\u0003D\u0006)\u0011\r\\5bgB!QCa\u000bo\u0011\u001d\u00119M\u000bC\u0001\u0005\u0013\f\u0001#[:UK6\u0004xN]1ssR\u000b'\r\\3\u0015\t\u0005E%1\u001a\u0005\t\u0003{\u0011)\r1\u0001\u0002p!9!q\u001a\u0016\u0005\u0002\tE\u0017A\u00037jgR$\u0016M\u00197fgR!!1\u001bBk!\u0019\t9-a6\u0002p!9\u0011Q\rBg\u0001\u0004q\u0007b\u0002BhU\u0011\u0005!\u0011\u001c\u000b\u0007\u0005'\u0014YN!8\t\u000f\u0005\u0015$q\u001ba\u0001]\"9\u00111\u001dBl\u0001\u0004q\u0007b\u0002BqU\u0011\u0005!1]\u0001\re\u00164'/Z:i)\u0006\u0014G.\u001a\u000b\u0005\u0003K\u0011)\u000f\u0003\u0005\u0002>\t}\u0007\u0019AA8\u0011\u001d\u0011IO\u000bC\u0001\u0005W\fqb\u00197fCJ$V-\u001c9UC\ndWm\u001d\u000b\u0003\u0003KAqAa<+\t\u0003\u0011\t0\u0001\tde\u0016\fG/\u001a)beRLG/[8ogRA\u0011Q\u0005Bz\u0005o\u001c\u0019\u0001\u0003\u0005\u0003v\n5\b\u0019AA8\u0003%!\u0018M\u00197f\u001d\u0006lW\r\u0003\u0005\u0003z\n5\b\u0019\u0001B~\u0003\u0015\u0001\u0018M\u001d;t!\u0019\t9-a6\u0003~B\u0019\u0001Ca@\n\u0007\r\u0005!AA\u000bDCR\fGn\\4UC\ndW\rU1si&$\u0018n\u001c8\t\u0011\u0005=%Q\u001ea\u0001\u0003#Cqaa\u0002+\t\u0003\u0019I!\u0001\bee>\u0004\b+\u0019:uSRLwN\\:\u0015\u0011\u0005\u001521BB\u0007\u0007'A\u0001B!>\u0004\u0006\u0001\u0007\u0011q\u000e\u0005\t\u0007\u001f\u0019)\u00011\u0001\u0004\u0012\u0005)1\u000f]3dgB1\u0011qYAl\u0005'B\u0001\"!)\u0004\u0006\u0001\u0007\u0011\u0011\u0013\u0005\b\u0007/QC\u0011AB\r\u0003A\u0011XM\\1nKB\u000b'\u000f^5uS>t7\u000f\u0006\u0005\u0002&\rm1QDB\u0010\u0011!\u0011)p!\u0006A\u0002\u0005=\u0004\u0002CB\b\u0007+\u0001\ra!\u0005\t\u0011\r\u00052Q\u0003a\u0001\u0007#\t\u0001B\\3x'B,7m\u001d\u0005\b\u0007KQC\u0011AB\u0014\u0003=\tG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cHCBA\u0013\u0007S\u0019Y\u0003\u0003\u0005\u0003v\u000e\r\u0002\u0019AA8\u0011!\u0011Ipa\tA\u0002\tm\bbBB\u0018U\u0011\u00051\u0011G\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0007\u0005{\u001c\u0019d!\u000e\t\u0011\tU8Q\u0006a\u0001\u0003_B\u0001ba\u000e\u0004.\u0001\u0007!1K\u0001\u0005gB,7\rC\u0004\u0004<)\"\ta!\u0010\u0002\u001d1L7\u000f\u001e)beRLG/[8ogR1!1`B \u0007\u0003B\u0001B!>\u0004:\u0001\u0007\u0011q\u000e\u0005\u000b\u0007\u0007\u001aI\u0004%AA\u0002\r\u0015\u0013a\u00039beRL\u0017\r\\*qK\u000e\u0004R!\u0006B\u0016\u0005'Bqa!\u0013+\t\u0013\u0019Y%\u0001\u0011sKF,\u0018N]3Fq\u0006\u001cG/T1uG\",G\rU1si&$\u0018n\u001c8Ta\u0016\u001cGCBA\u0013\u0007\u001b\u001ay\u0005\u0003\u0005\u0004\u0010\r\u001d\u0003\u0019AB\t\u0011!\u0019\tfa\u0012A\u0002\t\r\u0011!\u0002;bE2,\u0007bBB+U\u0011%1qK\u0001#e\u0016\fX/\u001b:f!\u0006\u0014H/[1m\u001b\u0006$8\r[3e!\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0015\r\u0005\u00152\u0011LB.\u0011!\u0019yaa\u0015A\u0002\rE\u0001\u0002CB)\u0007'\u0002\rAa\u0001\t\u000f\r}#\u0006\"\u0001\u0004b\u0005q1M]3bi\u00164UO\\2uS>tGCBA\u0013\u0007G\u001ai\u0007\u0003\u0005\u0004f\ru\u0003\u0019AB4\u000391WO\\2EK\u001aLg.\u001b;j_:\u00042\u0001EB5\u0013\r\u0019YG\u0001\u0002\u0010\u0007\u0006$\u0018\r\\8h\rVt7\r^5p]\"A\u0011qRB/\u0001\u0004\t\t\nC\u0004\u0004r)\"\taa\u001d\u0002\u0019\u0011\u0014x\u000e\u001d$v]\u000e$\u0018n\u001c8\u0015\r\u0005\u00152QOB?\u0011!\tida\u001cA\u0002\r]\u0004cA$\u0004z%\u001911\u0010\u0003\u0003%\u0019+hn\u0019;j_:LE-\u001a8uS\u001aLWM\u001d\u0005\t\u0003C\u001by\u00071\u0001\u0002\u0012\"91\u0011\u0011\u0016\u0005\u0002\r\r\u0015aE4fi\u001a+hn\u0019;j_:lU\r^1eCR\fG\u0003BB4\u0007\u000bC\u0001\"!\u0010\u0004\u0000\u0001\u00071q\u000f\u0005\b\u0007\u0013SC\u0011ABF\u000391WO\\2uS>tW\t_5tiN$B!!%\u0004\u000e\"A\u0011QHBD\u0001\u0004\u00199\bC\u0004\u0004\u0012*\"\taa%\u0002'5\f7.\u001a$v]\u000e$\u0018n\u001c8Ck&dG-\u001a:\u0015\r\rU51XB_!\u0011\u00199j!.\u000f\t\re5\u0011\u0017\b\u0005\u00077\u001byK\u0004\u0003\u0004\u001e\u000e5f\u0002BBP\u0007WsAa!)\u0004*:!11UBT\u001d\u0011\tYm!*\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002B\t%\u001911\u0017!\u0002!\u0019+hn\u0019;j_:\u0014VmZ5tiJL\u0018\u0002BB\\\u0007s\u0013qBR;oGRLwN\u001c\"vS2$WM\u001d\u0006\u0004\u0007g\u0003\u0005bBA\u001f\u0007\u001f\u0003\rA\u001c\u0005\b\u0007\u007f\u001by\t1\u0001o\u0003E1WO\\2uS>t7\t\\1tg:\u000bW.\u001a\u0005\b\u0007\u0007TC\u0011ABc\u0003Uaw.\u00193Gk:\u001cG/[8o%\u0016\u001cx.\u001e:dKN$B!!\n\u0004H\"A1\u0011ZBa\u0001\u0004\u0019Y-A\u0005sKN|WO]2fgB1\u0011qYAl\u0007\u001b\u00042\u0001EBh\u0013\r\u0019\tN\u0001\u0002\u0011\rVt7\r^5p]J+7o\\;sG\u0016Dqa!6+\t\u0003\u00199.\u0001\nde\u0016\fG/\u001a+f[B4UO\\2uS>tGCCA\u0013\u00073\u001cYna;\u0004n\"9\u0011QHBj\u0001\u0004q\u0007\u0002CBo\u0007'\u0004\raa8\u0002\t%tgm\u001c\t\u0005\u0007C\u001c9/\u0004\u0002\u0004d*\u00191Q\u001d\u0003\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0007S\u001c\u0019O\u0001\bFqB\u0014Xm]:j_:LeNZ8\t\u0011\r\u001541\u001ba\u0001\u0007+C\u0001\"a$\u0004T\u0002\u0007\u0011\u0011\u0013\u0005\b\u0007cTC\u0011ABz\u0003A!'o\u001c9UK6\u0004h)\u001e8di&|g\u000e\u0006\u0004\u0002&\rU8q\u001f\u0005\b\u0003{\u0019y\u000f1\u0001o\u0011!\t\tka<A\u0002\u0005E\u0005bBB~U\u0011E1Q`\u0001\u0013M\u0006LGNR;oGRLwN\u001c'p_.,\b\u000f\u0006\u0003\u0004\u0000\u0012\u0015\u0001cA\u000b\u0005\u0002%\u0019A1\u0001\f\u0003\u000f9{G\u000f[5oO\"9\u0011QHB}\u0001\u0004q\u0007b\u0002C\u0005U\u0011\u0005A1B\u0001\u0013Y>|7.\u001e9Gk:\u001cG/[8o\u0013:4w\u000e\u0006\u0003\u0004`\u00125\u0001\u0002CA\u001f\t\u000f\u0001\raa\u001e\t\u000f\u0011E!\u0006\"\u0001\u0005\u0014\u0005qAn\\8lkB4UO\\2uS>tGC\u0002C\u000b\t7!i\u0002\u0005\u0003\u0004b\u0012]\u0011\u0002\u0002C\r\u0007G\u0014!\"\u0012=qe\u0016\u001c8/[8o\u0011!\ti\u0004b\u0004A\u0002\r]\u0004\u0002\u0003C\u0010\t\u001f\u0001\r\u0001\"\t\u0002\u0011\rD\u0017\u000e\u001c3sK:\u0004b!a2\u0002X\u0012U\u0001b\u0002C\u0013U\u0011\u0005AqE\u0001\u000eY&\u001cHOR;oGRLwN\\:\u0015\t\u0011%B\u0011\u0007\t\u0007\u0003\u000f\f9\u000eb\u000b\u0011\rU!ica\u001eo\u0013\r!yC\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015D1\u0005a\u0001]\"9AQ\u0005\u0016\u0005\u0002\u0011UBC\u0002C\u0015\to!I\u0004C\u0004\u0002f\u0011M\u0002\u0019\u00018\t\u000f\u0005\rH1\u0007a\u0001]\"9AQ\b\u0016\u0005\u0002\t-\u0018!\u0002:fg\u0016$\b\"\u0003C!UE\u0005I\u0011\u0001C\"\u0003aawn\\6vaJ+G.\u0019;j_:$C-\u001a4bk2$HEM\u000b\u0003\t\u000bRCAa1\u0005H-\u0012A\u0011\n\t\u0005\t\u0017\"\u0019&\u0004\u0002\u0005N)!Aq\nC)\u0003%)hn\u00195fG.,GMC\u0002\u0002\nYIA\u0001\"\u0016\u0005N\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0011e#&%A\u0005\u0002\u0011m\u0013\u0001\u00077jgR\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011AQ\f\u0016\u0005\u0007\u000b\"9\u0005")
public class SessionCatalog
implements Logging {
    public final ExternalCatalog org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog;
    public final FunctionResourceLoader org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader;
    public final FunctionRegistry org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry;
    private final CatalystConf conf;
    private final Configuration hadoopConf;
    @GuardedBy(value="this")
    private final HashMap<String, LogicalPlan> tempTables;
    @GuardedBy(value="this")
    private String currentDb;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static String DEFAULT_DATABASE() {
        return SessionCatalog$.MODULE$.DEFAULT_DATABASE();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public HashMap<String, LogicalPlan> tempTables() {
        return this.tempTables;
    }

    public String currentDb() {
        return this.currentDb;
    }

    public void currentDb_$eq(String x$1) {
        this.currentDb = x$1;
    }

    public String formatTableName(String name2) {
        return this.conf.caseSensitiveAnalysis() ? name2 : name2.toLowerCase();
    }

    public String formatDatabaseName(String name2) {
        return this.conf.caseSensitiveAnalysis() ? name2 : name2.toLowerCase();
    }

    private Path makeQualifiedPath(String path) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(this.hadoopConf);
        return fs.makeQualified(hadoopPath);
    }

    public void org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(String db) {
        if (this.databaseExists(db)) {
            return;
        }
        throw new NoSuchDatabaseException(db);
    }

    private void requireTableExists(TableIdentifier name2) {
        if (this.tableExists(name2)) {
            return;
        }
        String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        throw new NoSuchTableException(db, name2.table());
    }

    private void requireTableNotExists(TableIdentifier name2) {
        if (this.tableExists(name2)) {
            String db = (String)name2.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            throw new TableAlreadyExistsException(db, name2.table());
        }
    }

    public void createDatabase(CatalogDatabase dbDefinition, boolean ignoreIfExists) {
        String dbName;
        String qualifiedPath = this.makeQualifiedPath(dbDefinition.locationUri()).toString();
        String x$6 = dbName = this.formatDatabaseName(dbDefinition.name());
        String x$7 = qualifiedPath;
        String x$8 = dbDefinition.copy$default$2();
        Map<String, String> x$9 = dbDefinition.copy$default$4();
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createDatabase(dbDefinition.copy(x$6, x$8, x$7, x$9), ignoreIfExists);
    }

    public void dropDatabase(String db, boolean ignoreIfNotExists, boolean cascade) {
        String dbName;
        String string = dbName = this.formatDatabaseName(db);
        String string2 = SessionCatalog$.MODULE$.DEFAULT_DATABASE();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not drop default database"})).s((Seq)Nil$.MODULE$), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        String string3 = dbName;
        String string4 = this.getCurrentDatabase();
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can not drop current database `", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dbName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropDatabase(dbName, ignoreIfNotExists, cascade);
    }

    public void alterDatabase(CatalogDatabase dbDefinition) {
        String dbName = this.formatDatabaseName(dbDefinition.name());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(dbName);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterDatabase(dbDefinition.copy(dbName, dbDefinition.copy$default$2(), dbDefinition.copy$default$3(), dbDefinition.copy$default$4()));
    }

    public CatalogDatabase getDatabaseMetadata(String db) {
        String dbName = this.formatDatabaseName(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(dbName);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getDatabase(dbName);
    }

    public boolean databaseExists(String db) {
        String dbName = this.formatDatabaseName(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.databaseExists(dbName);
    }

    public Seq<String> listDatabases() {
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listDatabases();
    }

    public Seq<String> listDatabases(String pattern) {
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listDatabases(pattern);
    }

    public synchronized String getCurrentDatabase() {
        return this.currentDb();
    }

    public void setCurrentDatabase(String db) {
        String dbName = this.formatDatabaseName(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(dbName);
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            this.currentDb_$eq(dbName);
            return;
        }
    }

    public String getDefaultDBPath(String db) {
        String database2 = this.formatDatabaseName(db);
        return new Path(new Path(this.conf.warehousePath()), new StringBuilder().append((Object)database2).append((Object)".db").toString()).toString();
    }

    public void createTable(CatalogTable tableDefinition, boolean ignoreIfExists) {
        String db = this.formatDatabaseName((String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableDefinition.identifier().table());
        CatalogTable newTableDefinition = tableDefinition.copy(new TableIdentifier(table, (Option<String>)new Some((Object)db)), tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12(), tableDefinition.copy$default$13(), tableDefinition.copy$default$14(), tableDefinition.copy$default$15(), tableDefinition.copy$default$16());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createTable(db, newTableDefinition, ignoreIfExists);
    }

    public void alterTable(CatalogTable tableDefinition) {
        String db = this.formatDatabaseName((String)tableDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableDefinition.identifier().table());
        TableIdentifier tableIdentifier = new TableIdentifier(table, (Option<String>)new Some((Object)db));
        CatalogTable newTableDefinition = tableDefinition.copy(tableIdentifier, tableDefinition.copy$default$2(), tableDefinition.copy$default$3(), tableDefinition.copy$default$4(), tableDefinition.copy$default$5(), tableDefinition.copy$default$6(), tableDefinition.copy$default$7(), tableDefinition.copy$default$8(), tableDefinition.copy$default$9(), tableDefinition.copy$default$10(), tableDefinition.copy$default$11(), tableDefinition.copy$default$12(), tableDefinition.copy$default$13(), tableDefinition.copy$default$14(), tableDefinition.copy$default$15(), tableDefinition.copy$default$16());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(tableIdentifier);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterTable(db, newTableDefinition);
    }

    public synchronized boolean tableExists(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.tableExists(db, table);
    }

    public CatalogTable getTableMetadata(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTable(db, table);
    }

    public Option<CatalogTable> getTableMetadataOption(TableIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTableOption(db, table);
    }

    public void loadTable(TableIdentifier name2, String loadPath, boolean isOverwrite, boolean holdDDLTime) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.loadTable(db, table, loadPath, isOverwrite, holdDDLTime);
    }

    public void loadPartition(TableIdentifier name2, String loadPath, Map<String, String> partition, boolean isOverwrite, boolean holdDDLTime, boolean inheritTableSpecs, boolean isSkewedStoreAsSubdir) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)new Some((Object)db)));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.loadPartition(db, table, loadPath, partition, isOverwrite, holdDDLTime, inheritTableSpecs, isSkewedStoreAsSubdir);
    }

    public String defaultTablePath(TableIdentifier tableIdent) {
        String dbName = this.formatDatabaseName((String)tableIdent.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String dbLocation = this.getDatabaseMetadata(dbName).locationUri();
        return new Path(new Path(dbLocation), this.formatTableName(tableIdent.table())).toString();
    }

    public void createTempView(String name2, LogicalPlan tableDefinition, boolean overrideIfExists) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            String table = this.formatTableName(name2);
            if (this.tempTables().contains((Object)table) && !overrideIfExists) {
                throw new TempTableAlreadyExistsException(name2);
            }
            this.tempTables().put((Object)table, (Object)tableDefinition);
            return;
        }
    }

    public synchronized Option<LogicalPlan> getTempView(String name2) {
        return this.tempTables().get((Object)this.formatTableName(name2));
    }

    public void dropTempView(String name2) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            this.tempTables().remove((Object)this.formatTableName(name2));
            return;
        }
    }

    public synchronized CatalogTable getTempViewOrPermanentTableMetadata(TableIdentifier name2) {
        String table = this.formatTableName(name2.table());
        return name2.database().isDefined() ? this.getTableMetadata(name2) : (CatalogTable)this.getTempView(table).map((Function1)new Serializable(this, table){
            public static final long serialVersionUID = 0L;
            private final String table$1;

            public final CatalogTable apply(LogicalPlan plan2) {
                TableIdentifier x$10 = TableIdentifier$.MODULE$.apply(this.table$1);
                CatalogTableType x$11 = CatalogTableType$.MODULE$.VIEW();
                CatalogStorageFormat x$12 = CatalogStorageFormat$.MODULE$.empty();
                Seq x$13 = (Seq)plan2.output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CatalogColumn apply(Attribute c) {
                        return new CatalogColumn(c.name(), c.dataType().catalogString(), c.nullable(), CatalogColumn$.MODULE$.apply$default$4());
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Map x$14 = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
                None$ x$15 = None$.MODULE$;
                Seq<String> x$16 = CatalogTable$.MODULE$.apply$default$5();
                Seq<String> x$17 = CatalogTable$.MODULE$.apply$default$6();
                Seq<String> x$18 = CatalogTable$.MODULE$.apply$default$7();
                int x$19 = CatalogTable$.MODULE$.apply$default$8();
                String x$20 = CatalogTable$.MODULE$.apply$default$9();
                long x$21 = CatalogTable$.MODULE$.apply$default$10();
                long x$22 = CatalogTable$.MODULE$.apply$default$11();
                Option<String> x$23 = CatalogTable$.MODULE$.apply$default$13();
                Option<String> x$24 = CatalogTable$.MODULE$.apply$default$15();
                Seq<String> x$25 = CatalogTable$.MODULE$.apply$default$16();
                return new CatalogTable(x$10, x$11, x$12, (Seq<CatalogColumn>)x$13, x$16, x$17, x$18, x$19, x$20, x$21, x$22, (Map<String, String>)x$14, x$23, (Option<String>)x$15, x$24, x$25);
            }
            {
                this.table$1 = table$1;
            }
        }).getOrElse((Function0)new Serializable(this, name2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;
            private final TableIdentifier name$1;

            public final CatalogTable apply() {
                return this.$outer.getTableMetadata(this.name$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void renameTable(TableIdentifier oldName, TableIdentifier newName) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            void var5_5;
            void var4_4;
            String db = this.formatDatabaseName((String)oldName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
            String newDb = this.formatDatabaseName((String)newName.database().getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SessionCatalog $outer;

                public final String apply() {
                    return this.$outer.currentDb();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            String string = db;
            String string2 = newDb;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                BoxedUnit boxedUnit;
                String oldTableName = this.formatTableName(oldName.table());
                String newTableName = this.formatTableName(newName.table());
                if (!oldName.database().isDefined() && this.tempTables().contains((Object)oldTableName)) {
                    if (newName.database().isDefined()) {
                        throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TEMPORARY TABLE from '", "' to '", "': cannot specify database "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName, newName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name '", "' in the destination table"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newName.database().get()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    if (this.tempTables().contains((Object)newTableName)) {
                        throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TEMPORARY TABLE from '", "' to '", "': destination table already exists"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldName, newName})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                    }
                    LogicalPlan table = (LogicalPlan)this.tempTables().apply((Object)oldTableName);
                    this.tempTables().remove((Object)oldTableName);
                    boxedUnit = this.tempTables().put((Object)newTableName, (Object)table);
                } else {
                    this.requireTableExists(new TableIdentifier(oldTableName, (Option<String>)new Some((Object)db)));
                    this.requireTableNotExists(new TableIdentifier(newTableName, (Option<String>)new Some((Object)db)));
                    this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.renameTable(db, oldTableName, newTableName);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new AnalysisException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RENAME TABLE source and destination databases do not match: '", "' != '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var4_4, var5_5})), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dropTable(TableIdentifier name2, boolean ignoreIfNotExists) {
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            void var5_5;
            void var4_4;
            block8: {
                block6: {
                    Option option;
                    block7: {
                        String table;
                        String db;
                        block5: {
                            db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ SessionCatalog $outer;

                                public final String apply() {
                                    return this.$outer.currentDb();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            table = this.formatTableName(name2.table());
                            if (name2.database().isDefined() || !this.tempTables().contains((Object)table)) break block5;
                            option = this.tempTables().remove((Object)table);
                            break block6;
                        }
                        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
                        if (!this.tableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)))) break block7;
                        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropTable(db, table, true);
                        option = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!ignoreIfNotExists) break block8;
                    option = BoxedUnit.UNIT;
                }
                return;
            }
            throw new NoSuchTableException((String)var4_4, (String)var5_5);
        }
    }

    public synchronized LogicalPlan lookupRelation(TableIdentifier name2, Option<String> alias) {
        LogicalPlan logicalPlan;
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.currentDb();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(name2.table());
        if (!name2.database().isDefined() && this.tempTables().contains((Object)table)) {
            logicalPlan = (LogicalPlan)this.tempTables().apply((Object)table);
        } else {
            CatalogTable metadata2 = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getTable(db, table);
            logicalPlan = new SimpleCatalogRelation(db, metadata2, alias);
        }
        LogicalPlan relation = logicalPlan;
        SubqueryAlias qualifiedTable = new SubqueryAlias(table, relation);
        return (LogicalPlan)alias.map((Function1)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply(String a) {
                return new SubqueryAlias(a, this.qualifiedTable$1);
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        }).getOrElse((Function0)new Serializable(this, qualifiedTable){
            public static final long serialVersionUID = 0L;
            private final SubqueryAlias qualifiedTable$1;

            public final SubqueryAlias apply() {
                return this.qualifiedTable$1;
            }
            {
                this.qualifiedTable$1 = qualifiedTable$1;
            }
        });
    }

    public Option<String> lookupRelation$default$2() {
        return None$.MODULE$;
    }

    public synchronized boolean isTemporaryTable(TableIdentifier name2) {
        return name2.database().isEmpty() && this.tempTables().contains((Object)this.formatTableName(name2.table()));
    }

    public Seq<TableIdentifier> listTables(String db) {
        return this.listTables(db, "*");
    }

    public Seq<TableIdentifier> listTables(String db, String pattern) {
        String dbName = this.formatDatabaseName(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(dbName);
        Seq dbTables = (Seq)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listTables(dbName, pattern).map((Function1)new Serializable(this, dbName){
            public static final long serialVersionUID = 0L;
            private final String dbName$1;

            public final TableIdentifier apply(String t) {
                return new TableIdentifier(t, (Option<String>)new Some((Object)this.dbName$1));
            }
            {
                this.dbName$1 = dbName$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        SessionCatalog sessionCatalog = this;
        synchronized (sessionCatalog) {
            Seq _tempTables = (Seq)StringUtils$.MODULE$.filterPattern((Seq<String>)this.tempTables().keys().toSeq(), pattern).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final TableIdentifier apply(String t) {
                    return TableIdentifier$.MODULE$.apply(t);
                }
            }, Seq$.MODULE$.canBuildFrom());
            Object object = dbTables.$plus$plus((GenTraversableOnce)_tempTables, Seq$.MODULE$.canBuildFrom());
            return (Seq)object;
        }
    }

    public void refreshTable(TableIdentifier name2) {
        if (name2.database().isEmpty()) {
            this.tempTables().get((Object)this.formatTableName(name2.table())).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(LogicalPlan x$1) {
                    x$1.refresh();
                }
            });
        }
    }

    public synchronized void clearTempTables() {
        this.tempTables().clear();
    }

    public void createPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts, boolean ignoreIfExists) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)parts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(CatalogTablePartition x$2) {
                return x$2.spec();
            }
        }, Seq$.MODULE$.canBuildFrom())), this.getTableMetadata(tableName));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createPartitions(db, table, parts, ignoreIfExists);
    }

    public void dropPartitions(TableIdentifier tableName, Seq<Map<String, String>> specs, boolean ignoreIfNotExists) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.requirePartialMatchedPartitionSpec(specs, this.getTableMetadata(tableName));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropPartitions(db, table, specs, ignoreIfNotExists);
    }

    public void renamePartitions(TableIdentifier tableName, Seq<Map<String, String>> specs, Seq<Map<String, String>> newSpecs) {
        CatalogTable tableMetadata = this.getTableMetadata(tableName);
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.requireExactMatchedPartitionSpec(specs, tableMetadata);
        this.requireExactMatchedPartitionSpec(newSpecs, tableMetadata);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.renamePartitions(db, table, specs, newSpecs);
    }

    public void alterPartitions(TableIdentifier tableName, Seq<CatalogTablePartition> parts) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)parts.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(CatalogTablePartition x$3) {
                return x$3.spec();
            }
        }, Seq$.MODULE$.canBuildFrom())), this.getTableMetadata(tableName));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.alterPartitions(db, table, parts);
    }

    public CatalogTablePartition getPartition(TableIdentifier tableName, Map<String, String> spec) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        this.requireExactMatchedPartitionSpec((Seq<Map<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{spec}))), this.getTableMetadata(tableName));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getPartition(db, table, spec);
    }

    public Seq<CatalogTablePartition> listPartitions(TableIdentifier tableName, Option<Map<String, String>> partialSpec) {
        String db = this.formatDatabaseName((String)tableName.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        String table = this.formatTableName(tableName.table());
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        this.requireTableExists(new TableIdentifier(table, (Option<String>)Option$.MODULE$.apply((Object)db)));
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listPartitions(db, table, partialSpec);
    }

    public Option<Map<String, String>> listPartitions$default$2() {
        return None$.MODULE$;
    }

    private void requireExactMatchedPartitionSpec(Seq<Map<String, String>> specs, CatalogTable table) {
        Seq defined = (Seq)table.partitionColumnNames().sorted((Ordering)Ordering.String$.MODULE$);
        specs.foreach((Function1)new Serializable(this, table, defined){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$2;
            private final Seq defined$1;

            public final void apply(Map<String, String> s) {
                Object object = s.keys().toSeq().sorted((Ordering)Ordering.String$.MODULE$);
                Seq seq = this.defined$1;
                if (!(object != null ? !object.equals(seq) : seq != null)) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec is invalid. The spec (", ") must match "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.keys().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the partition spec (", ") defined in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$2.partitionColumnNames().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$2.identifier()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.table$2 = table$2;
                this.defined$1 = defined$1;
            }
        });
    }

    private void requirePartialMatchedPartitionSpec(Seq<Map<String, String>> specs, CatalogTable table) {
        Seq<String> defined = table.partitionColumnNames();
        specs.foreach((Function1)new Serializable(this, table, defined){
            public static final long serialVersionUID = 0L;
            private final CatalogTable table$3;
            public final Seq defined$2;

            public final void apply(Map<String, String> s) {
                if (s.keys().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$requirePartialMatchedPartitionSpec$1 $outer;

                    public final boolean apply(Object elem) {
                        return this.$outer.defined$2.contains(elem);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                })) {
                    return;
                }
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition spec is invalid. The spec (", ") must be contained "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{s.keys().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"within the partition spec (", ") defined "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$3.partitionColumnNames().mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"in table '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table$3.identifier()}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.table$3 = table$3;
                this.defined$2 = defined$2;
            }
        });
    }

    public void createFunction(CatalogFunction funcDefinition, boolean ignoreIfExists) {
        String db = this.formatDatabaseName((String)funcDefinition.identifier().database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        FunctionIdentifier identifier = new FunctionIdentifier(funcDefinition.identifier().funcName(), (Option<String>)new Some((Object)db));
        CatalogFunction newFuncDefinition = funcDefinition.copy(identifier, funcDefinition.copy$default$2(), funcDefinition.copy$default$3());
        if (this.functionExists(identifier)) {
            if (!ignoreIfExists) {
                throw new FunctionAlreadyExistsException(db, identifier.toString());
            }
        } else {
            this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.createFunction(db, newFuncDefinition);
        }
    }

    public void dropFunction(FunctionIdentifier name2, boolean ignoreIfNotExists) {
        FunctionIdentifier identifier;
        String db;
        block4: {
            block3: {
                block2: {
                    db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ SessionCatalog $outer;

                        public final String apply() {
                            return this.$outer.getCurrentDatabase();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
                    Some x$26 = new Some((Object)db);
                    String x$27 = name2.copy$default$1();
                    identifier = name2.copy(x$27, (Option<String>)x$26);
                    if (!this.functionExists(identifier)) break block2;
                    Object object = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(identifier.unquotedString()) ? BoxesRunTime.boxToBoolean((boolean)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.dropFunction(identifier.unquotedString())) : BoxedUnit.UNIT;
                    this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.dropFunction(db, name2.funcName());
                    break block3;
                }
                if (!ignoreIfNotExists) break block4;
            }
            return;
        }
        throw new NoSuchFunctionException(db, identifier.toString());
    }

    public CatalogFunction getFunctionMetadata(FunctionIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(db, name2.funcName());
    }

    public boolean functionExists(FunctionIdentifier name2) {
        String db = this.formatDatabaseName((String)name2.database().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply() {
                return this.$outer.getCurrentDatabase();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(name2.unquotedString()) || this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.functionExists(db, name2.funcName());
    }

    public Function1<Seq<Expression>, Expression> makeFunctionBuilder(String name2, String functionClassName) {
        throw new UnsupportedOperationException("Use sqlContext.udf.register(...) instead.");
    }

    public void loadFunctionResources(Seq<FunctionResource> resources) {
        resources.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(FunctionResource resource) {
                this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader.loadResource(resource);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void createTempFunction(String name2, ExpressionInfo info, Function1<Seq<Expression>, Expression> funcDefinition, boolean ignoreIfExists) {
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunctionBuilder(name2).isDefined() && !ignoreIfExists) {
            throw new TempFunctionAlreadyExistsException(name2);
        }
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.registerFunction(name2, info, funcDefinition);
    }

    public void dropTempFunction(String name2, boolean ignoreIfNotExists) {
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.dropFunction(name2) || ignoreIfNotExists) {
            return;
        }
        throw new NoSuchTempFunctionException(name2);
    }

    public Nothing$ failFunctionLookup(String name2) {
        throw new NoSuchFunctionException(this.currentDb(), name2);
    }

    public synchronized ExpressionInfo lookupFunctionInfo(FunctionIdentifier name2) {
        Option database2;
        Option x$28 = database2 = name2.database().orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final Some<String> apply() {
                return new Some((Object)this.$outer.currentDb());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply(String name2) {
                return this.$outer.formatDatabaseName(name2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String x$29 = name2.copy$default$1();
        FunctionIdentifier qualifiedName = name2.copy(x$29, (Option<String>)x$28);
        return (ExpressionInfo)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(name2.funcName()).orElse((Function0)new Serializable(this, qualifiedName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;
            private final FunctionIdentifier qualifiedName$1;

            public final Option<ExpressionInfo> apply() {
                return this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(this.qualifiedName$1.unquotedString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.qualifiedName$1 = qualifiedName$1;
            }
        }).getOrElse((Function0)new Serializable(this, name2, qualifiedName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;
            private final FunctionIdentifier name$2;
            private final FunctionIdentifier qualifiedName$1;

            public final ExpressionInfo apply() {
                String db = (String)this.qualifiedName$1.database().get();
                this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(db);
                if (this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.functionExists(db, this.name$2.funcName())) {
                    CatalogFunction metadata2 = this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(db, this.name$2.funcName());
                    return new ExpressionInfo(metadata2.className(), this.qualifiedName$1.unquotedString());
                }
                throw this.$outer.failFunctionLookup(this.name$2.funcName());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.name$2 = name$2;
                this.qualifiedName$1 = qualifiedName$1;
            }
        });
    }

    public synchronized Expression lookupFunction(FunctionIdentifier name2, Seq<Expression> children2) {
        Option database2;
        if (name2.database().isEmpty() && this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(name2.funcName())) {
            return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(name2.funcName(), children2);
        }
        Option x$30 = database2 = name2.database().orElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final Some<String> apply() {
                return new Some((Object)this.$outer.currentDb());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final String apply(String name2) {
                return this.$outer.formatDatabaseName(name2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        String x$31 = name2.copy$default$1();
        FunctionIdentifier qualifiedName = name2.copy(x$31, (Option<String>)x$30);
        if (this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.functionExists(qualifiedName.unquotedString())) {
            return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(qualifiedName.unquotedString(), children2);
        }
        try {
            CatalogFunction catalogFunction = this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.getFunction(this.currentDb(), name2.funcName());
            this.loadFunctionResources(catalogFunction.resources());
            ExpressionInfo info = new ExpressionInfo(catalogFunction.className(), qualifiedName.unquotedString());
            Function1<Seq<Expression>, Expression> builder = this.makeFunctionBuilder(qualifiedName.unquotedString(), catalogFunction.className());
            this.createTempFunction(qualifiedName.unquotedString(), info, builder, false);
        }
        catch (NoSuchPermanentFunctionException noSuchPermanentFunctionException) {
            throw this.failFunctionLookup(name2.funcName());
        }
        catch (AnalysisException analysisException) {
            throw this.failFunctionLookup(name2.funcName());
        }
        return this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.lookupFunction(qualifiedName.unquotedString(), children2);
    }

    public Seq<Tuple2<FunctionIdentifier, String>> listFunctions(String db) {
        return this.listFunctions(db, "*");
    }

    public Seq<Tuple2<FunctionIdentifier, String>> listFunctions(String db, String pattern) {
        String dbName = this.formatDatabaseName(db);
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$requireDbExists(dbName);
        Seq dbFunctions = (Seq)this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog.listFunctions(dbName, pattern).map((Function1)new Serializable(this, dbName){
            public static final long serialVersionUID = 0L;
            private final String dbName$2;

            public final FunctionIdentifier apply(String f) {
                return new FunctionIdentifier(f, (Option<String>)new Some((Object)this.dbName$2));
            }
            {
                this.dbName$2 = dbName$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq loadedFunctions = (Seq)StringUtils$.MODULE$.filterPattern(this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.listFunction(), pattern).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FunctionIdentifier apply(String f) {
                return FunctionIdentifier$.MODULE$.apply(f);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq functions = (Seq)dbFunctions.$plus$plus((GenTraversableOnce)loadedFunctions, Seq$.MODULE$.canBuildFrom());
        return (Seq)functions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<FunctionIdentifier, String> apply(FunctionIdentifier x0$1) {
                FunctionIdentifier functionIdentifier = x0$1;
                Tuple2 tuple2 = FunctionRegistry$.MODULE$.functionSet().contains((Object)functionIdentifier.funcName()) ? new Tuple2((Object)functionIdentifier, (Object)"SYSTEM") : new Tuple2((Object)functionIdentifier, (Object)"USER");
                return tuple2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public synchronized void reset() {
        this.setCurrentDatabase(SessionCatalog$.MODULE$.DEFAULT_DATABASE());
        ((IterableLike)this.listDatabases().filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                String string = x$4;
                String string2 = SessionCatalog$.MODULE$.DEFAULT_DATABASE();
                return string != null ? !string.equals(string2) : string2 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(String db) {
                this.$outer.dropDatabase(db, false, true);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.listTables(SessionCatalog$.MODULE$.DEFAULT_DATABASE()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(TableIdentifier table) {
                this.$outer.dropTable(table, false);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        ((IterableLike)this.listFunctions(SessionCatalog$.MODULE$.DEFAULT_DATABASE()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FunctionIdentifier apply(Tuple2<FunctionIdentifier, String> x$5) {
                return (FunctionIdentifier)x$5._1();
            }
        }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(FunctionIdentifier func) {
                if (func.database().isDefined()) {
                    this.$outer.dropFunction(func, false);
                } else {
                    this.$outer.dropTempFunction(func.funcName(), false);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.tempTables().clear();
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.clear();
        FunctionRegistry$.MODULE$.builtin().listFunction().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SessionCatalog $outer;

            public final void apply(String f) {
                Option<ExpressionInfo> expressionInfo = FunctionRegistry$.MODULE$.builtin().lookupFunction(f);
                Option<Function1<Seq<Expression>, Expression>> functionBuilder = FunctionRegistry$.MODULE$.builtin().lookupFunctionBuilder(f);
                Predef$.MODULE$.require(expressionInfo.isDefined(), (Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final String f$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"built-in function '", "' is missing expression info"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                Predef$.MODULE$.require(functionBuilder.isDefined(), (Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final String f$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"built-in function '", "' is missing function builder"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f$1}));
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
                this.$outer.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry.registerFunction(f, (ExpressionInfo)expressionInfo.get(), (Function1<Seq<Expression>, Expression>)((Function1)functionBuilder.get()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionResourceLoader functionResourceLoader, FunctionRegistry functionRegistry, CatalystConf conf, Configuration hadoopConf) {
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$externalCatalog = externalCatalog;
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionResourceLoader = functionResourceLoader;
        this.org$apache$spark$sql$catalyst$catalog$SessionCatalog$$functionRegistry = functionRegistry;
        this.conf = conf;
        this.hadoopConf = hadoopConf;
        Logging.class.$init$((Logging)this);
        this.tempTables = new HashMap();
        String defaultName = SessionCatalog$.MODULE$.DEFAULT_DATABASE();
        CatalogDatabase defaultDbDefinition = new CatalogDatabase(defaultName, "default database", conf.warehousePath(), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        this.createDatabase(defaultDbDefinition, true);
        this.currentDb = this.formatDatabaseName(defaultName);
    }

    public SessionCatalog(ExternalCatalog externalCatalog, FunctionRegistry functionRegistry, CatalystConf conf) {
        this(externalCatalog, DummyFunctionResourceLoader$.MODULE$, functionRegistry, conf, new Configuration());
    }

    public SessionCatalog(ExternalCatalog externalCatalog) {
        this(externalCatalog, new SimpleFunctionRegistry(), new SimpleCatalystConf(true, SimpleCatalystConf$.MODULE$.$lessinit$greater$default$2(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$3(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$4(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$5(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$6(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$7(), SimpleCatalystConf$.MODULE$.$lessinit$greater$default$8()));
    }
}

