<?php

# Code expects a field "source" containing either "News" or "Social" if filter is used
# Also expects a "url" field and a "doc" type. Finally, expects "body" to 
# contain the full text.
$eshostname = 'fiji11';
$esport = '9200';
$esindex = 'kba2012';
$estimefield = 'stream_time';

date_default_timezone_set("UTC");
function convertdate($in) {
  if (preg_match("/\d+\/\d+\/\d+/",$in)) {
    $d = explode("/",$in);
    #$dn = sprintf("%s-%s-%s",$d[2],$d[0],$d[1]);
    #return (new \DateTime($dn))->getTimestamp();
    return sprintf("%s-%s-%s",$d[2],$d[0],$d[1]);
  } else {
    return $in;
  }
}
function indent($json) {

    $result      = '';
    $pos         = 0;
    $strLen      = strlen($json);
    $indentStr   = '  ';
    $newLine     = "\n";
    $prevChar    = '';
    $outOfQuotes = true;

    for ($i=0; $i<=$strLen; $i++) {

        // Grab the next character in the string.
        $char = substr($json, $i, 1);

        // Are we inside a quoted string?
        if ($char == '"' && $prevChar != '\\') {
            $outOfQuotes = !$outOfQuotes;

        // If this character is the end of an element, // output a new line and indent the next line.
        } else if(($char == '}' || $char == ']') && $outOfQuotes) {
            $result .= $newLine;
            $pos --;
            for ($j=0; $j<$pos; $j++) {
                $result .= $indentStr;
            }
        }

        // Add the character to the result string.
        $result .= $char;

        // If the last character was the beginning of an element,
        // output a new line and indent the next line.
        if (($char == ',' || $char == '{' || $char == '[') && $outOfQuotes) {
            $result .= $newLine;
            if ($char == '{' || $char == '[') {
                $pos ++;
            }

            for ($j = 0; $j < $pos; $j++) {
                $result .= $indentStr;
            }
        }

        $prevChar = $char;
    }

    return $result;
}

/** 
 * Send a POST requst using cURL 
 * @param string $url to request 
 * @param array $post values to send 
 * @param array $options for cURL 
 * @return string 
 */ 
function curl_post($url, array $post = NULL, array $options = array()) 
{ 
  $enc = json_encode($post);
#  $enc = str_replace("[]","{}",$enc);
  #echo("<pre>".indent($enc)."</pre>");
  $defaults = array( 
      CURLOPT_POST => 1, 
      CURLOPT_HEADER => 0, 
      CURLOPT_URL => $url, 
      CURLOPT_FRESH_CONNECT => 1, 
      CURLOPT_RETURNTRANSFER => 1, 
      CURLOPT_FORBID_REUSE => 1, 
      CURLOPT_TIMEOUT => 4, 
      CURLOPT_POST => 1,
      CURLOPT_POSTFIELDS => $enc
  ); 

  $ch = curl_init(); 
  curl_setopt_array($ch, ($options + $defaults)); 
  if( ! $result = curl_exec($ch)) 
  { 
      trigger_error(curl_error($ch)); 
  } 
  curl_close($ch); 
  return $result; 
} 
FUNCTION shorturl($url){
    $length = STRLEN($url);
    IF($length > 45){
        $length = $length - 30;
        $first = SUBSTR($url, 0, -$length);
        $last = SUBSTR($url, -15);
        $new = $first."[ ... ]".$last;
        RETURN $new;
    }ELSE{
        RETURN $url;
    }
}

function printNav() {
  global $start, $count, $hits;
  echo '<div class="nav">';
  if ($start > 0) {
    echo '<a href="" onClick="getPrev()">Prev</a>';
  }
  $curr = 1 + floor($start / 10);
  $i = max(1, $curr - 5);
  $end = min($i + 10,floor($hits / 10));
  while($i < $end) {
    if ($i == $curr) {
      echo " $i";
    } else {
      echo " <a href=\"javascript:getPage('$i')\">$i</a>";
    }
    $i++;
  }
  if ($start+$count < $hits) {
    echo ' <a href="javascript:getNext()">Next</a>';
  }
  echo '</div>';
}
#require 'vendor/autoload.php';

if ($_GET) {
  require_once __DIR__ . '/vendor/autoload.php';
  $elasticaClient = new \Elastica\Client(array('host' => $eshostname, 'port' => $esport));
  $elasticaQueryString  = new Elastica\Query\QueryString();
  if (array_key_exists("id",$_GET)) {
    $elasticaQuery = new Elastica\Query\Ids("doc",array($_GET["id"]));
  } else {
    $elasticaQuery = new Elastica\Query("doc");

    $start = 0;
    $count = 10;
    if (array_key_exists("st",$_GET) and $_GET["st"] !== "") {
      $start = $_GET["st"];
    }
    if (array_key_exists("c",$_GET) and $_GET["c"] !== "") {
      $count = $_GET["c"];
    }

    $elasticaQuery->setFrom($start);    // Where to start?
    $elasticaQuery->setLimit($count);   // How many?
  }
  $elasticaIndex = $elasticaClient->getIndex($esindex);
  $elasticaFilter  = new \Elastica\Filter\BoolAnd();


  if (array_key_exists("qs",$_GET)) {
    $querystring = $_GET["qs"];
    #$request->query(Sherlock::query()->Term()->field("message")
    #                                   ->term("ElasticSearch"));
    $query["query"] = ["query_string" => [ "default_field" => "body", "query" => $querystring ]];
    $elasticaQueryString->setQuery($_GET["qs"]);
    $elasticaQuery->setQuery($elasticaQueryString);
    $elasticaQuery->setHighlight(array(
      "fields" => array(
        "body" => array(
          "fragment_size" => 200,
          "number_of_fragments" => 1
        )
      )
    ));
  }

  $query["filter"] = [];

  $source = $_GET["qc"];
  if ($source and $source != "all") {
    $query["filter"] = [
            "term" => [ 
              "source" => $source
            ]
          ];
    $elasticaFilterSource  = new \Elastica\Filter\Term();
    $elasticaFilterSource->setTerm('source', $source);
    $elasticaFilter->addFilter($elasticaFilterSource);
    $filter = 1;
  }

  $datefrom = $_GET["qdf"];
  $dateto = $_GET["qdt"];
  if ($datefrom or $dateto) {
    $streamtime = [];
    if ($datefrom) {
      $streamtime["from"] = convertdate($datefrom);
      #$streamtime["include_lower"] = true;
    }
    if ($dateto) {
      $streamtime["to"] = convertdate($dateto);
      #$streamtime["include_upper"] = true;
    }
    $query["filter"]["range"] = [ $estimefield => $streamtime ];
    #var_dump($streamtime);
    $elasticaFilterDate = new \Elastica\Filter\Range('stream_time',$streamtime);
    #$elasticaFilter->addFilter($elasticaFilterDate);
    #$elasticaFilterDate = new \Elastica\Filter\Range();
    #$elasticaFilterDate->addField('date',$streamtime);
    $elasticaFilter = $elasticaFilterDate;
    $filter = 1;
  }

  #$queryset = [];

  #if (count($query["filter"]) > 0) {
  #  $fullquery = ["query" => ["filtered" => &$query]];
  #  $queryset = &$fullquery["query"];
  #  $queryset["fields"] = array("stream_time", "source", "url");
  #} else {
  #  unset($query["filter"]);
  #  $queryset = &$query;
  #  $fullquery = &$queryset;
  #  $queryset["fields"] = array("stream_time", "source", "url");
  #}

  #$queryset["highlight"] = [ "fields" => [ "body" => [ "number_of_fragments" => 1 ] ] ];

  if (!array_key_exists("id",$_GET)) {
    $elasticaQuery->setFields(array($estimefield, "source", "url"));
    $elasticaFacetDate = new \Elastica\Facet\DateHistogram("date");
    $elasticaFacetDate->setField($estimefield);
    $elasticaFacetDate->setInterval("2h");
    #$elasticaFacetSource = new \Elastica\Facet\Terms("source");
    #$elasticaFacetSource->setField("source");
    #$elasticaFacetSource->setAllTerms(true);
    #$elasticaQuery->addFacet($elasticaFacetDate);
    #$elasticaQuery->addFacet($elasticaFacetSource);
  }

  if ($filter) {
    #$elasticaQuery->setFilter($elasticaFilter);
    #$elasticaQuery->setQuery(new \Elastica\Query\Filtered($elasticaQueryString,$elasticaFilter));
    $elasticaQuery->setFilter($elasticaFilter);
  }

  #$fullquery = [
  #  "query" => [
  #    "filtered" => [ 
  #      "query" => [ 
  #        "query_string" => [ 
  #          "query" => $_GET["qs"]
  #        ], 
  #        "filter" => [ 
  #          "term" => [ 
  #            "source" => $_GET["qc"]
  #          ]
  #        ]
  #      ]
  #    ]
  #  ]
  #];
  #$url = "http://localhost:9200/kba2012/doc/_search?".http_build_query([ "from" => $start, "size" => $count]);
  #
  #$result = curl_post($url, $fullquery);
  #$results = json_decode($result,true);
  #if (is_array($results) and array_key_exists("hits",$results)) {
  #  $hits = $results["hits"]["hits"];
  #  $total = $results["hits"]["total"];
  #}
  //Search on the index.
  #echo "<pre>";
  #print json_encode($elasticaQuery->toArray());
  #echo "</pre>";
  $elasticaResultSet = $elasticaIndex->search($elasticaQuery);
  $elasticaResults  = $elasticaResultSet->getResults();
  #$elasticaFacets  = $elasticaResultSet->getFacets();
  $hits     = $elasticaResultSet->getTotalHits();

  if (array_key_exists("raw",$_GET)) {
    if (array_key_exists("id",$_GET)) {
      foreach ($elasticaResults as $elasticaResult) {
        $data = $elasticaResult->getData();
        echo $data["body"];
      }
    } else {
      foreach ($elasticaResults as $elasticaResult) {
        $id = $elasticaResult->getId();
        $data = $elasticaResult->getData();
        $snippets = $elasticaResult->getHighlights();
        echo $id."\n";
      }
    }
    exit;
  }
  
  #echo "<pre>";
  #foreach ($elasticaResults as $elasticaResult) {
  #    var_dump($elasticaResult->getData());
  #    var_dump($elasticaResult->getHighlights());
  #}
  #echo "</pre>";
}
?>
<html lang="en">
<head>
  <meta charset="utf-8" />
  <link rel="stylesheet" href="http://code.jquery.com/ui/1.10.2/themes/smoothness/jquery-ui.css" />
  <script src="http://code.jquery.com/jquery-1.9.1.js" ></script>
  <script src="http://code.jquery.com/ui/1.10.2/jquery-ui.js" ></script>
  <script src="http://code.jquery.com/ui/1.10.2/jquery-ui.js" ></script>
  <script src="http://d3js.org/d3.v3.min.js"></script>
  <style type="text/css">
  em { font-weight: bold;font-style: normal; }
  .hit { margin: 0 0 30px 0; width: 600px; }
  .doc { width: 900px; }
  .nav { margin: 20px 0 20px 0; }
  .right { float: right; }
  .main { float: left; }
  </style>
  <script type="text/javascript">
    var start = <?php echo $start; ?>;
    var count = <?php echo $count; ?>;
    function getNext() {
      getPage(((start + count) / count) + 1);
    }
    function getPrev() {
      getPage(((start - count) / count) + 1);
    }
    function getPage(i) {
      $("#st").val((i-1)*count);
      $("#c").val(count);
      $("#search").submit();
      return false;
    }
    $(document).ready(function () {
      $( "#qdf" ).datepicker({
        defaultDate: "+1d",
        onClose: function( selectedDate ) {
          $( "#qdt" ).datepicker( "option", "minDate", selectedDate );
        }
      });
      $( "#qdt" ).datepicker({
        defaultDate: "+1d",
        onClose: function( selectedDate ) {
          $( "#qdf" ).datepicker( "option", "maxDate", selectedDate );
        }
      });
    });
  </script>
</head>
<body>
<form name="search" id="search" method="GET">
<p>Search: <input type="text" name="qs" size="30" <?php if ($_GET["qs"]) { echo 'value="'.$_GET["qs"].'"'; } ?>></input>
Category:
<select name="qc">
<option value="all" <?php if (!$_GET["qc"] || $_GET["qc"] == "all") { echo "selected"; } ?>>All</option>
<option value="social" <?php if ($_GET["qc"] && $_GET["qc"] == "social") { echo "selected"; } ?>>Social</option>
<option value="news" <?php if ($_GET["qc"] && $_GET["qc"] == "news") { echo "selected"; } ?>>News</option>
</select>
Date: <input type="text" name="qdf" id="qdf" class="datepicker" <?php if ($_GET["qdf"]) { echo 'value="'.$_GET["qdf"].'"'; } ?>></input>-<input type="text" name="qdt" id="qdt" class="datepicker" <?php if ($_GET["qdt"]) { echo 'value="'.$_GET["qdt"].'"'; } ?>></input>
<input type="submit" value="Go" /></p>
<input type="hidden" id="st" name="st" />
<input type="hidden" id="c" name="c" />
</form>
<?php
if (array_key_exists("id",$_GET)) {
  foreach ($elasticaResults as $elasticaResult) {
    $data = $elasticaResult->getData();
    echo '<div class="doc">';
    echo $data["body"];
    echo '</div>';
    echo "<pre>";
    var_dump($elasticaResult);
    echo "</pre>";
  }
} else {
  printNav();
  #echo '<div id="right">';
  #$dates = $elasticaFacets["date"]["entries"];
  #echo '<div id="dates">';
  #foreach ($dates as $date) {
  #  echo '<a href="javascript:getTime(\''.$date["time"].'\')">'.date("Y/m/d H:i:s",$date["time"]) . "</a>: " . $date["count"].'<br />';
  #}
  #echo '</div>';
  #echo '</div>';
  echo '<div id="main">';
  foreach ($elasticaResults as $elasticaResult) {
    $id = $elasticaResult->getId();
    $data = $elasticaResult->getData();
    $snippets = $elasticaResult->getHighlights();
    echo '<div class="hit"><div><a href="querykba.php?id='.$id.'">'.$id.'</a> - '.$data["source"].' - '.$data[$estimefield].'</div>';
    echo '<div class="url"><a href="'.$data["url"].'">'.shorturl($data["url"]).'</a></div>';
    echo '<div class="content">'.$snippets["body"][0].'...</div></div>';
  }
  #echo "<pre>";
  #var_dump($elasticaFacets);
  #echo "</pre>";
  echo '</div>';
  printNav();
}
#foreach ($hits as $hit) {
#  $source = $hit['fields'];
#  echo '<div class="hit"><div><a href="">'.$hit["_id"].'</a> - '.$source["source"].' - '.$source["stream_time"].'</div>';
#  echo '<div class="url"><a href="'.$source["url"].'">'.shorturl($source["url"]).'</a></div>';
#  echo '<div class="content">'.$hit["highlight"]["body"][0].'</div></div>';
#}
#echo("<pre>".indent($result)."</pre>");
?>
</body>
</html>
