::This script is part of
::l2w v1.0 by Emanuele Viola
::Distributable version

::I can do everything with htlatex EXCEPT getting the labels inside equations.
::So the first part is aimed to substitute those labels with the actual numbers
::Known bugs: This only works if the labels start with "eq:"
::The way it does it is to first get the post.aux file
::That file essentially contains the appropriate substitutions.
::It only remains to put them into the perl format and then run them.
::To do: \label is turned into ~~~~(4), would be good
::To place it better
::
::Coloring \subsection* doesn't work

latex post.tex
bibtex post
latex post.tex
latex post.tex

copy post.aux post.bat

::Removes all lines that don't begin with \newlabel{eq:
perl -p -i.bak -e "s/^(?!\\newlabel\{eq:).*//g" post.bat

::For each line that does begin with \newlabel, it parses it and inserts two new lines
::corresponding to the substitutions in the perl format operating on file post2.tex
::The important thing is that in perl you can use $1, $2 for the strings that matched.
::Note, I use delimiter # which is not a valid latex label
::The second line works for the format of \newlabel in .aux WITHOUT hyperref, which is
::\newlabel{ak}{{2}{3}}
::
::The first one is for the format WITH hyperref, which is
::\newlabel{eq:bla}{{1}{1}{\relax }{equation.0.1}{}}
::

::I apply both

perl -p -i.bak -e "s/\\newlabel\{(.*)\}\{\{(.*)\}\{(.*)\}\{(.*)\}\{(.*)\}\{(.*)\}\}/perl -p -i.bak -e \"s#\\\\label\\\{$1\\\}#\~\~\~\~\($2\)#g\" post2.tex \n perl -p -i.bak -e \"s#\\\\ref\\\{$1\\\}#\($2\)#g\" post2.tex /g" post.bat
perl -p -i.bak -e "s/\\newlabel\{(.*)\}\{\{(.*)\}\{(.*)\}\}/perl -p -i.bak -e \"s#\\\\label\\\{$1\\\}#\~\~\~\~\($2\)#g\" post2.tex \n perl -p -i.bak -e \"s#\\\\ref\\\{$1\\\}#\($2\)#g\" post2.tex /g" post.bat

copy post.tex post2.tex

CALL post.bat

::Done applying labels to post2.tex

::Now a hack: Remove the breakurl package which clashes with htlatex
perl -p -i.bak -e "s/.*\\usepackage\{breakurl\}.*//g" post2.tex

::Because align and equations aren't supported, we now turn them into aligned environments, which
::can be used inside math environments and so work on Wordpress

:: Turning align into $aligned$

perl -p -i.bak -e "s/\\begin{align}/\$\\begin{aligned}/g" post2.tex
perl -p -i.bak -e "s/\\end{align}/\\end{aligned}\$/g" post2.tex

::Same with align*

perl -p -i.bak -e "s/\\begin{align\*}/\$\\begin{aligned}/g" post2.tex
perl -p -i.bak -e "s/\\end{align\*}/\\end{aligned}\$/g" post2.tex

:: Turning equation into $aligned$

perl -p -i.bak -e "s/\\begin{equation}/\$\\begin{aligned}/g" post2.tex
perl -p -i.bak -e "s/\\end{equation}/\\end{aligned}\$/g" post2.tex

::We also need the bibliography.  For that we need to generate the .bbl file

::compiles post2 to generate .bbl
::cf. https://tex.stackexchange.com/questions/53235/why-does-latex-bibtex-need-three-passes-to-clear-up-all-warnings
::latex post2
::bibtex post2
::latex post2
::latex post2

copy post.bbl post2.bbl

::Now finally uses htlatex with myConfig5.
htlatex post2.tex "myConfig5"

::Removing extra space between begin {align} and end {align}

perl -p -i.bak -e "s/\s\{aligned\}/\{aligned\}/g" post2.html

::Adding HTML commands to center align

perl -p -i.bak -e "s/\$latex \\begin\{aligned\}/<div style=\"text-align: center;\"> $&/g" post2.html
perl -p -i.bak -e "s/\\end\{aligned\}\$/$& <\/div>/g" post2.html

::Replacing spurious spaces

perl -p -i.bak -e "s/\n/ /g" post2.html

::Replace \E with \mathbb{E}
::
::perl -p -i.bak -e "s#\\E#\\mathbb\{E\}#g" post2.html

copy post2.html post.html