;;; Print out a simpla hex arrays with characters.
;;; Copyright (c) 1995 by Olin Shivers.

;;; This code prints out hex grids with characters. These procedures
;;; aren't used for anything; I just wrote them to build up to the hex
;;; maze printer in an incremental fashion.

;;;    _   _
;;;  _/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ 

(define (print-hexes nrows ncols)
  ;; Print out the flat tops for the top row's odd cols.
  (do ((c 0 (+ c 2)))
      ((= c ncols))
    (display "   _"))
  (newline)

  ;; Print out the slanted tops for the top row's odd cols
  ;; and the flat tops for the top row's even cols.
  (display " ")
  (do ((c 0 (+ c 2)))
      ((= c ncols))
    (display "_/ \\"))
  (newline)


  (do ((r (- nrows 1) (- r 1)))
      ((< r 0))

    ;; Do the bottoms for row r's odd cols.
    (display "/")
    (do ((c 0 (+ c 2)))
	((= c ncols))
      (display " \\_/"))
    (newline)

    ;; Do the bottoms for row r's even cols.
    (do ((c 0 (+ c 2)))
	((= c ncols))
      (display "\\_/ "))
    (if (not (zero? r)) (display "\\"))
    (newline)))


(define (print-hexes nrows ncols)
  ;; Print out the flat tops for the top row's odd cols.
  (do ((c 0 (+ c 2)))
      ((= c ncols))
    (display "   _"))
  (newline)

  (do ((r (- nrows 1) (- r 1)))
      ((< r 0))
    ;; Do the flat parts of the cell tops for row r's even cols,
    ;; and the slanted parts of the cell tops for row r's odd cols.
    (display (if (= r (- nrows 1)) " " "\\"))
    (do ((c 0 (+ c 2)))
	((= c ncols))
      (display "_/ \\"))
    (newline)

    ;; Do the slanted parts of the cell tops for row r's even cols,
    ;; and the flat parts of the cell tops for row r-1's odd cols.
    (do ((c 0 (+ c 2)))
	((= c ncols))
      (display "/ \\_"))
    (display "/")
    (newline))

  ;; Do the bottoms for row 0's even cols.
  (do ((c 0 (+ c 2)))
      ((= c ncols))
    (display "\\_/ "))
  (newline))

    
;;; Top part of row looks like this:
;;;    _   _  _   _
;;;  _/ \_/ \/ \_/ \
;;; /        

;;; This version handles odd-column cases.

(define (print-hexes nrows ncols)
  (let ((ncols2 (* 2 (quotient ncols 2))))
    ;; Print out the flat tops for the top row's odd cols.
    (do ((c 0 (+ c 2)))
	((>= c ncols2))
      (display "   _"))
    (newline)

    ;; Print out the slanted tops for the top row's odd cols
    ;; and the flat tops for the top row's even cols.
    (display " ")
    (do ((c 0 (+ c 2)))
	((>= c ncols2))
      (display "_/ \\"))
    (if (odd? ncols) (display "_"))
    (newline)

    (do ((r (- nrows 1) (- r 1)))
	((< r 0))

      ;; Do the bottoms for row r's odd cols.
      (display "/")
      (do ((c 0 (+ c 2)))
	  ((>= c ncols2))
	(display " \\_/"))
      (if (odd? ncols) (display " \\"))
      (newline)

      ;; Do the bottoms for row r's even cols.
      (do ((c 0 (+ c 2)))
	  ((>= c ncols2))
	(display "\\_/ "))
      (display (cond ((odd? ncols) "\\_/")
		     ((zero? r)    "")
		     (else         "\\")))
      (newline))))
