;;; Print out a hex array with characters.
;;; Copyright (c) 1995 by Olin Shivers.

;;; External dependencies:
;;; - hex array code
;;; - hex cell code

;;;    _   _
;;;  _/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ 

;;; Top part of top row looks like this:
;;;    _   _  _   _
;;;  _/ \_/ \/ \_/ \
;;; /        

(define (print-hexmaze harr entrance)
  (let* ((nrows  (harr:nrows harr))
	 (ncols  (harr:ncols harr))
	 (ncols2 (* 2 (quotient ncols 2))))

    ;; Print out the flat tops for the top row's odd cols.
    (do ((c 1 (+ c 2)))
	((>= c ncols))
      (display "   ")
      (write-char (if (= c entrance) #\space #\_)))
    (newline)

    ;; Print out the slanted tops for the top row's odd cols
    ;; and the flat tops for the top row's even cols.
    (write-char #\space)
    (do ((c 0 (+ c 2)))
	((>= c ncols2))
      (format #t "~a/~a\\"
	      (if (= c entrance) #\space #\_)
	      (dot/space harr (- nrows 1) (+ c 1))))
    (if (odd? ncols)
	(write-char (if (= entrance (- ncols 1)) #\space #\_)))
    (newline)

    (do ((r (- nrows 1) (- r 1)))
	((< r 0))

      ;; Do the bottoms for row r's odd cols.
      (write-char #\/)
      (do ((c 1 (+ c 2)))
	  ((>= c ncols2))
	;; The dot/space for the even col just behind c.
	(write-char (dot/space harr r (- c 1)))
	(display-hexbottom (cell:walls (href/rc harr r c))))	

      (cond ((odd? ncols)
	     (write-char (dot/space harr r (- ncols 1)))
	     (write-char #\\)))
      (newline)

      ;; Do the bottoms for row r's even cols.
      (do ((c 0 (+ c 2)))
	  ((>= c ncols2))
	(display-hexbottom (cell:walls (href/rc harr r c)))
	;; The dot/space is for the odd col just after c, on row below.
	(write-char (dot/space harr (- r 1) (+ c 1))))
      
      (cond ((odd? ncols)
	     (display-hexbottom (cell:walls (href/rc harr r (- ncols 1)))))
	    ((not (zero? r)) (write-char #\\)))
      (newline))))

(define (bit-test j bit)
  (not (zero? (bitwise-and j bit))))

;;; Return a . if harr[r,c] is marked, otherwise a space.
;;; We use the dot to mark the solution path.
(define (dot/space harr r c)
  (if (and (>= r 0) (cell:mark (href/rc harr r c))) #\. #\space))

;;; Print a \_/ hex bottom.
(define (display-hexbottom hexwalls)
  (write-char (if (bit-test hexwalls south-west) #\\ #\space))
  (write-char (if (bit-test hexwalls south     ) #\_ #\space))
  (write-char (if (bit-test hexwalls south-east) #\/ #\space)))

;;;    _   _
;;;  _/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \_/
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \
;;; / \_/ \_/
;;; \_/ \_/ \_/
