             <<< ALIEN::DISK$DATA01:[NOTES$LIBRARY]XLISP.NOTE;1 >>>
                          -< LISP without apologies >-
================================================================================
Note 53.0         Unix-customization and modified print-routine          1 reply
UTR01::DEHARTOG "AI is better than none!"           118 lines  11-MAR-1987 04:18
--------------------------------------------------------------------------------

Here is the makefile for Unix. Note that dependency from xlisp.h is
not mentioned here; so if you change anything in xlisp.h, you should
recompile all modules.
The difference with the PC-world is the file xlunix.c (in place of
pcstuff.c or msstuff.c). It contains two lispfunctions: SH which allows
you to give any unix-command from xlisp by (sh "unix-command") and
SCNDS which results in the number of seconds since some time ago.
Note that the -i in the cc-command is for separate I&D space only
(i.e for the PRO380, ommit it for the PRO350).

objects=xlisp.o xlbfun.o xlcont.o xldbug.o xldmem.o xleval.o xlfio.o\
 xlftab.o xlglob.o xlinit.o xlio.o xljump.o xllist.o xlmath.o\
 xlobj.o xlprin.o xlread.o xlstr.o xlsubr.o xlsym.o xlsys.o\
 xlunix.o lstksiz.o
xlisp : $(objects)
	cc -o xlisp -i -s $(objects) -lm
---------------------------------------------------------------------
Here is a modified version of the routine printit (from module xlfio.c).
It makes the lisp-function PRINT behave as in normal (Common) Lisp (i.e.
it starts with a newline and prints a space at the end). The original
print did not print a space at the end, but did the newline at the end.

/* printit - common print function */
LOCAL NODE *printit(args,pflag,tflag)
  NODE *args; int pflag,tflag;
{
    NODE *fptr,*val;

    /* get expression to print and file pointer */
    val = xlarg(&args);
    fptr = (args ? xlgetfile(&args) : getvalue(s_stdout));
    xllastarg(args);

    /* start with newline if necessary */
    if (tflag)
	xlterpri(fptr);

    /* print the value */
    xlprint(fptr,val,pflag);

    /* follow with a space if necessary */
    if (tflag)
	xlputc(fptr, ' ');

    /* return the result */
    return (val);
}
-------------------------------------------------------------------------
Here is the module xlunix.c :
===========================

#include "xlisp.h"

extern NODE *true;
extern int errno;

/* osinit - os specific initialization */
osinit(banner)
  char *banner;
{
    printf("%s\n",banner);
	srand(getpid());	/* for random-function */
}

/* osgetc - get a character from a file (or stdin) */
int osgetc(fp)
  FILE *fp;
{
    return (getc(fp));
}

/* osputc - write a character to a file (or stdout) */
int osputc(ch,fp)
  int ch;
  FILE *fp;
{
    return (putc(ch,fp));
}

/* oscheck - check for control characters */
oscheck()
{
}

/* osrand - return a random number between 0 and n-1 */
int osrand(n)
  int n;
{
    return (rand() % n);
}

/* osfinish - clean up before returning to the operating system */
osfinish()
{
}

/* xshell - shell escape for unix */
NODE *xshell(args) NODE *args;{
	char *cmd;
	cmd = xlmatch(STR, &args)->n_str;
	xllastargs(args);
	return(system(cmd) ? cvfixnum((FIXNUM)errno) : true);
}

/* xseconds - return clocktime in seconds since some time */
NODE *xseconds(args) NODE *args;{
	long time();

	xllastargs(args);
	return(cvfixnum((FIXNUM)time((long *) 0)));
}

/* osfinit - initialize unix specific functions */
osfinit()
{
	xlsubr("SH",	SUBR,	xshell);
	xlsubr("SCNDS",	SUBR,	xseconds);
}
