#include "../CountMsg.h"

module BaseM{

	provides{
	interface StdControl;
	}

	uses{
	interface Leds;
	interface Timer2<TMilli> as Timer;
	interface Timer2<TMilli> as TimerTSR;
	interface SendMsg;
	interface CC2420Control;
	interface ReceiveMsg;


	}

}

implementation{

  TOS_Msg m_msg;
  uint16_t parentId;
  uint16_t nodeId;

  command result_t StdControl.init() {

	nodeId = TOS_LOCAL_ADDRESS;
	
	return SUCCESS;

  }

  command result_t StdControl.start() {

	call Timer.startPeriodic( TIMER_PERIOD - 500 );
	call CC2420Control.SetRFPower(RESOURCE_NONE, RADIO_POWER); 
	return SUCCESS;

  }

  command result_t StdControl.stop() {

	call Timer.stop();
	return SUCCESS;

  }

  event void Timer.fired() {
	CountMsg_t* body = (CountMsg_t*)m_msg.data;
	body -> src = nodeId;
	body -> hopcount = 1;
	body -> packetType = HOP_PKT;
	call Leds.set(1);
	call SendMsg.send( TOS_BCAST_ADDR, sizeof(CountMsg_t), &m_msg);

  }

event void TimerTSR.fired()
{
	call Leds.set(1);
}
   
  event result_t SendMsg.sendDone( TOS_MsgPtr msg, result_t success ) {
	return SUCCESS;

  }

  event TOS_MsgPtr ReceiveMsg.receive( TOS_MsgPtr msg ) {
	uint8_t ptype;
	CountMsg_t* body = (CountMsg_t*)msg->data;
	ptype = body -> packetType;
	if(ptype == TSR_PKT)
	{
		call Leds.set(7);
		call TimerTSR.startOneShot(500);

	}
	return msg;

  }




}