

includes IntMsg;

module IntToRfmM 
{
  uses {
    interface StdControl as SubControl;
    interface SendMsg as Send;
	interface Timer as ResendTimer;
  }
  provides {
    interface Output;
    interface StdControl;
  }
}
implementation
{
  bool pending;
  
  struct TOS_Msg data;
  uint16_t buffer[50][3];
  int MaxReTrans;
  int start,end;
  int i;
  command result_t StdControl.init() {
    pending = FALSE;
	MaxReTrans=50;
	start=0;
	end=0;
 
    return call SubControl.init();
  }

  command result_t StdControl.start() 
  {
	call ResendTimer.start(TIMER_REPEAT, TOS_LOCAL_ADDRESS*5+30);  
    
	return call SubControl.start();
  }


    command result_t StdControl.stop() 
  {
    call ResendTimer.stop();
    return call SubControl.stop();
  }

  command result_t Output.output(uint16_t seq, uint16_t dest,bool onetime,int counter)
  {
   		  if(TOS_LOCAL_ADDRESS==dest)
		  		return SUCCESS;					 
   		  if(((end+1)%50)==start)
		  		return FAIL;
		  
		  atomic {
		    buffer[end][0]=seq;
		    buffer[end][1]=dest;
			if(onetime)
				buffer[end][2]=1;
			else
				buffer[end][2]=MaxReTrans;
		    end=(end+1)%50;
		  }
		  return SUCCESS;
   
  }
  command void Output.removeCmd(uint16_t val){
	atomic {
		for(i=0;i<50;i++){
			if(buffer[i][0]==val)
				buffer[i][2]=0;
		}
	}
		
  }
  command void Output.removeAll(){
		start=end;
  }

  event result_t Send.sendDone(TOS_MsgPtr msg, result_t success)
  {
    if (pending && msg == &data)
    {
	   		atomic {
				//if(msg->ack==1||buffer[start][1]==TOS_BCAST_ADDR)
	   			//   	start=(start+1)%50;
				if(buffer[start][2]<=1&&start!=end)
					start=(start+1)%50;
				else
				{
					buffer[end][0]=buffer[start][0];
					buffer[end][1]=buffer[start][1];
					buffer[end][2]=buffer[start][2]-1;
					start=(start+1)%50;
					end=(end+1)%50;
					
				}
			}
			pending = FALSE;
			signal Output.outputComplete(success);
    }
    return SUCCESS;
  }
   event result_t ResendTimer.fired()
  {
   		
   	 if(start!=end){
   	      IntMsg *message = (IntMsg *)data.data;
          
		  if (!pending) 
  	      {
		    //dbg(DBG_TEMP, "Sending to %i\n", buffer[start][1]);
			pending = TRUE;
			if(buffer[start][2]>0)//if 0 skip sending.
			{
				message->val = buffer[start][0];
				atomic {
					message->src = TOS_LOCAL_ADDRESS;
				}
			
				if (call Send.send(buffer[start][1], sizeof(IntMsg), &data))
				return SUCCESS;
			}else
			{
				start=(start+1)%50;
			}
			pending = FALSE;
           }
	  }
      return FAIL;
  }
}




