

module IntToLedsM {
  uses interface Leds;

  provides interface Output;
  provides interface StdControl;
}
implementation
{
  command result_t StdControl.init()
  {
    call Leds.init();
    call Leds.redOff();
    call Leds.yellowOff();
    call Leds.greenOff();
    return SUCCESS;
  }

  command result_t StdControl.start() {
    return SUCCESS;
  }

  command result_t StdControl.stop() {
    return SUCCESS;
  }
  

  task void outputDone()
  {
    signal Output.outputComplete(1);
  }

  command result_t Output.output(uint16_t value, uint16_t dest, int counter)
  {
   	//dbg(DBG_TEMP, "Counter: Value is %i\n", counter);
    if (counter & 1) call Leds.redOn();
    else call Leds.redOff();
    if (counter & 2) call Leds.greenOn();
    else call Leds.greenOff();
    if (counter & 4) call Leds.yellowOn();
    else call Leds.yellowOff();

    post outputDone();

    return SUCCESS;
  }
}

