/*
 * A sample message type definition
 * @author Richard Jia
 */

#ifndef TOPOCTRLMSG_H
#define TOPOCTRLMSG_H

#define  BASE_STATION_ID 0
#define  TOPO_RETRANS_MAX 0
#define  MAX_FORWARD_DELAY 100
#define  MAX_FORWARD_REPLY_DELAY 100
#define  MAX_REPLY_DELAY 200
#define  MAX_RETRANS_DELAY 300
#define  BASE_STATION_EPOCH_PERIOD 4000

struct TopoCtrlMsg {
  uint16_t srcNodeID;
  uint16_t seqNo;
  uint8_t type;

  uint16_t payLoad_Parent; // parent node
  uint16_t payLoad_Child; // child  node
};

struct SimpleRoutingTable {
  uint16_t dest;
  uint16_t next;
};

enum {
  TOPO_CTRL_MSG = 19
};

enum {
  TOPO_CTRL_MSG_DISCOVERY = 3,
  TOPO_CTRL_MSG_DISCOVERY_REPLY = 5
};

#endif

