/**
*
* DaMultiHop.nc
* @author Daria Antonova
*
* Push-based Aggregation Tree and Node Count
* see README for description of this application
*/
includes DaConstants;

configuration DaMultiHop {
}
implementation {
  components Main, DaCounter, DaIntToLeds, TimerC, GenericComm as Comm, RandomLFSR;

  // Control behavior based on id
  Main.StdControl -> DaIntToLeds.StdControl;
  Main.StdControl -> DaCounter.StdControl;
  Main.StdControl -> Comm;
  DaIntToLeds <- DaCounter.IntOutput;
  Main.StdControl -> TimerC.StdControl;
  DaCounter.Timer -> TimerC.Timer[unique("Timer")];
  DaCounter.Random -> RandomLFSR.Random;

  // For sending/receiving
  DaCounter.Send -> Comm.SendMsg[AM_CNTMSG];
  DaCounter.ReceiveCntMsg -> Comm.ReceiveMsg[AM_CNTMSG];
}
