import java.net.*;
import java.io.*;

public class URLObserver implements Observer<String> {

    private URLObserver () {}

    public static URLObserver create () {
        return new URLObserver();
    }

    public void notify (String input) {
	if (input.startsWith("http://")) {
	    System.out.println(" Trying to read URL " + input);
	    try {
		URL url = new URL(input);
		BufferedReader in = 
		    new BufferedReader(new InputStreamReader(url.openStream()));
		String inputLine;
		while ((inputLine = in.readLine()) != null)
		    System.out.println(inputLine);
		in.close();
	    } catch (Exception e) {
		System.out.println(" Error trying to read URL: " + e.getMessage());
	    }
	}
    }
}
