
import java.io.*;
import java.util.*;

public class InputLoop implements Observable<String> {

    private LinkedList<Observer<String>> observers;

    private InputLoop () { 
        observers = new LinkedList<Observer<String>>();
    }

    public static InputLoop create () {
	return new InputLoop();
    }

    public void registerObserver (Observer<String> ob) {
        observers.add(ob);
    }

    public void notifyObservers (String arg) {
        for (Observer<String> item : this.observers) {
            item.notify(arg);
        }
    }

    private String getInput () {

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        String response = "";
    
        try {
            response = br.readLine();
            if (response==null) {
                return "";
            }
        } catch (IOException ioe) {
            System.out.println("IO error reading from terminal\n");
            System.exit(1);
        }
        return response;
    }

    public void loop () {

        String response;
        while (true) {
            System.out.print("> ");
            response = getInput();
            notifyObservers(response);
        }
    }


}
