
import java.io._
import java.net._

object Url {
  
  def create ():Subscriber[String] = new UrlImpl
  
  private class UrlImpl extends Subscriber[String] {
    
    def printUrlContent (input:String):Unit = {
      try {
	val url = new URL(input);
	val in = new BufferedReader(new InputStreamReader(url.openStream()));
	var inputLine = in.readLine()
	while (inputLine != null) {
	  println(inputLine)
	  inputLine = in.readLine()
	} 
      } catch {
	case e:Exception => println(" Error trying to read URL: " + 
				    e.getMessage())
      }
    }
    
    override def notify (data:String):Unit = {
        if (data.startsWith("http://"))
            printUrlContent(data);
    }
  }
}

