
object Substitution2 {

  def create ():Substitution2 = new SubstImpl

  abstract class Substitution2 
	   extends Publisher[String] with Subscriber[String]

  private class SubstImpl extends Substitution2 {

    private var map = SubstitutionMap.empty()

    private var subscribers = List.empty[Subscriber[String]]()

    def subscribe (s:Subscriber[String]):Unit = 
      subscribers = List.cons(s,subscribers)

    def broadcast (data:String):Unit = {
      def notifySubscriber (sub:Subscriber[String]):Unit = 
            sub.notify(this,data)
      subscribers.foreach(notifySubscriber)
    }
      
    override def notify (data:String):Unit = 
      if (data.startsWith("$ ")) {
	val res = data.split(" +",4)
	if (res.size >= 4 && res(2)=="=")
	  map = map.add(res(1),res(3))
      }	else 
	broadcast(map.subst(data))
  }
}
