
object SubstitutionMap {

  def empty ():SubstitutionMap = new SubstMap(List.empty())

  private class SubstMap (subs:List[Subst]) extends SubstitutionMap {
    
    def add (s:String,t:String):SubstitutionMap = 
      new SubstMap(List.cons(new Subst(s,t),subs))

    def subst (s:String):String = 
      subs.foldr((sub:Subst,s:String)=> sub.subst(s),s)
  }

  private class Subst (src:String, tgt:String) {

    def subst (s:String):String = {
      for (i <- 0 to s.size) {
	if (s.startsWith("${" + src + "}",i))
	  return subst(s.substring(0,i) + tgt + s.substring(i+3+src.size))
      }
      return s
    }
  }
}


abstract class SubstitutionMap {

  def add (s:String,t:String):SubstitutionMap
  def subst (s:String):String
}
