
object ResponseCreator {

  def create ():Subscriber[String] = new ResponseCreatorImpl()

  private class ResponseCreatorImpl () extends Subscriber[String] {

    override def notify (pub:Publisher[String], data:String):Unit = {
      if (data.startsWith("response")) {
	val res = data.split(" ")
	if (res.size >= 3) {
          println("Creating new response from " + res(1) + " to " + res(2))
          // if data is "response x y" res(0) -> "response" res(1) -> "x" res(2) -> "y"
          // here: create a new Response module from res(1) to res(2)
          // and subscribe it to the input loop
          val module = Response.create(res(1),res(2))
          pub.subscribe(module)
        }
      }
    }
  }
}
