
object List {

  def empty[T] ():List[T] = new ListEmpty[T]()

  def cons[T] (t:T, L:List[T]):List[T] = new ListCons[T](t,L)


  // EMPTY LIST REPRESENTATION
  //
  private class ListEmpty[T] () extends List[T] {
    def isEmpty ():Boolean = true
    def first ():T = 
      throw new RuntimeException("empty().first()")
    def rest ():List[T] = 
      throw new RuntimeException("empty().rest()")
    def length ():Int = 0
    def append (M:List[T]):List[T] = M
    def find (f:T):Boolean = false

    def foldr[U] (f:(T,U)=>U, b:U):U = b

    def foreach (f:(T)=>Unit):Unit = ()

    // canonical methods?

    override def toString ():String = ""
  }


  // CONS LIST REPRESENTATION
  //
  private class ListCons[T] (n:T, L:List[T]) extends List[T] {
    def isEmpty ():Boolean = false
    def first ():T = n
    def rest ():List[T] = L
    def length ():Int = 1 + L.length()
    def append (M:List[T]):List[T] = List.cons(n,L.append(M))
    def find (f:T):Boolean = { (f == n) || L.find(f) }

    def foldr[U] (f:(T,U)=>U, b:U):U = f(n,L.foldr(f,b))
    
    def foreach (f:(T)=>Unit):Unit = {
      f(n)
      L.foreach(f)
    }


    override def toString ():String = n + " " + L.toString()
  }
}


abstract class List[T] {

  def isEmpty ():Boolean
  def first ():T
  def rest (): List[T]
  def length ():Int
  def append (M:List[T]):List[T]
  def find (f:T):Boolean
  def foldr[U] (f:(T,U)=>U,b:U):U
  def foreach (f:(T)=>Unit):Unit 

}
