object InputLoop {

  def create ():InputLoop = new InputLoopImpl

  private class InputLoopImpl extends InputLoop {

    private var subscribers:List[Subscriber[String]] = List.empty()

    def subscribe (sub:Subscriber[String]):Unit = {
      subscribers = List.cons(sub,subscribers)
    }

    def broadcast (data:String):Unit = {
      // function to call on every subscriber in the list of subscribers
      def callNotify (sub:Subscriber[String]):Unit = sub.notify(this,data)
      subscribers.foreach(callNotify)
    }

    def loop ():Unit = {

      val s:String = readLine("> ")

      // Approach 1: add some logic here dependent on the string read
      // Echo back to the user 
      //println("You entered: " + s)
      // check for quit
      // if (s.startsWith("quit"))
      //  System.exit(0)

      // Approach 2: broadcast the string to subscribers

      broadcast(s)

      loop()
    }
  }
}


abstract class InputLoop extends Publisher[String] {

  def loop ():Unit
  def subscribe (sub:Subscriber[String]):Unit
  def broadcast (data:String):Unit

}
