
object StreamToIteratorAdapter {

  def create[T] (s:Stream[T]):StreamToIteratorAdapter[T] = 
    new StreamToIteratorAdapterRepr(s)

  private class StreamToIteratorAdapterRepr[T] (initStream:Stream[T]) 
                                    extends StreamToIteratorAdapter[T] {

    private var current:Stream[T] = initStream

    def hasNext ():Boolean = current.hasElement()

    def next ():T = {
      val first:T = current.head()
      current = current.tail()        // mutation
      first
    }
  }
}


abstract class StreamToIteratorAdapter[T] extends Iterator[T] {

  def hasNext ():Boolean
  def next ():T
}
