
object IteratorToStreamAdapter {

  def create[T] (it:Iterator[T]):IteratorToStreamAdapter[T] = 
    new IteratorToStreamAdapterRepr(it)

  private class IteratorToStreamAdapterRepr[T] (it:Iterator[T]) extends IteratorToStreamAdapter[T] {

    var first:Option[T] = if (it.hasNext) 
                            Option.some(it.next())
                          else
                            Option.none()

    def hasElement ():Boolean = !(first.isNone())

    def head ():T = if (first.isNone())
                      throw new RuntimeException("Empty stream")
                    else
                      first.valOf()

    def tail ():Stream[T] = if (first.isNone())
                              throw new RuntimeException("Empty stream")
                            else                      
                              new IteratorToStreamAdapterRepr(it)
  }
}


abstract class IteratorToStreamAdapter[T] extends Stream[T] {

  def hasElement ():Boolean
  def head ():T
  def tail ():Stream[T]
}


// val s = IteratorToStreamAdapter.create(it)
// s.head() --> first element from iterator
// s.head() --> first element from iterator
