
object IterationTest {

  def main (argv:Array[String]):Unit = run(argv)


  def run (a:Array[String]) = {

    println("Command-line arguments iteration = ")
    printN(a.iterator,10)
    println("Command-list arguments length iteration = ")
    printN(stringLengthIterator(a.iterator),10)
    println("")

    val b:Array[String] = Array("this","is","a","long","array","with","a",
				"lot","of","rather","boring","entries",
				"but","I","had","to","make","sure","that",
				"it","was","long","enough","to","exhibit",
				"the","behavior","I","wanted","to","exhibit")
    val bIter:Iterator[String] = b.iterator
    println("The full long array = " + b.mkString("[",",","]"))
    println("Long array iterator = ")
    printN(bIter,10)
    println("Long array length iterator (continued) = ")
    printN(stringLengthIterator(bIter),10)
    println("Long array iterator (continued) = ")
    printN(bIter,10)
    println("Long array length iterator (continued) = ")
    printN(stringLengthIterator(bIter),10)
    println("")

    for (i:String <- b) {
      println(" --> " + i)
    }

    val T = BinTree
    val T1:BinTree[String] = T.node("the",
				    T.node("quick",
					   T.node("brown",T.empty(),T.empty()),
					   T.empty()),
				    T.node("fox",
					   T.node("jumps",T.empty(),T.empty()),
					   T.node("over",
						  T.node("the",
							 T.node("lazy",
								T.empty(),
								T.empty()),
							 T.node("dog",
								T.empty(),
								T.empty())),
						  T.empty())))
    println("T1 = " + T1)
    println("Elements T1 (as a stream) = ")
    T1.print()
    println("Elements T1 (as a stream, paired with itself) = ")
    T1.zip(T1).print()
    val iter = T1.iterator()
    println("T1 iterator = ")
    printN(iter,3)
    println("T1 length iterator (continued) = ")
    printN(stringLengthIterator(iter),3)
    println("T1 iterator (continued) = ")
    printN(iter,3)
    println("")


    // an iterator delivering infinitely many pieces of data
    val sqIter:Iterator[Int] = Stream.intsFrom(1).map((x:Int)=> x*x).iterator()
    println("First 10 elements of the iterator = ")
    printN(sqIter,10)
    println("Next 10 elements of the iterator = ")
    printN(sqIter,10)
    println("Next  10 elements of the iterator = ")
    printN(sqIter,10)
    println("")

    // A real stream
    println("A real stream... first element of the stream T1 = " + 
	    T1.head())
    println("First element of the stream T1 again = " + T1.head())
    println("Printing the first five elements of T1 = ")
    T1.printN(5)
    println("Again printing the first five elements of T1 = ")
    T1.printN(5)
    println("")

    // deriving a stream from an iterator
    val bIter2:Iterator[String] = b.iterator
    val bStr2:Stream[String] = Stream.fromIterator(bIter2)
    println("The full long array = " + b.mkString("[",",","]"))
    println("First element of the stream = " + bStr2.head())
    println("First element of the stream again = " + bStr2.head())
    println("But printing the first five elements = ")
    bStr2.printN(5)
    println("And again the first five elements? = ")
    bStr2.printN(5)

    // MUTABILITY IS CONTAGIOUS, and iterators are mutable

    val str = Stream.fromIterator(T1.iterator())
    str.print()

    println("Messing with iteration:")
    val iter2 = T1.iterator()
    val str2 = Stream.fromIterator(iter2)
    println(" str2.head() = " + str2.head())
    println("Advancing underlying iterator")
    val dummy = iter2.next()
    println(" str2.head() = " + str2.head())
    println(" str2.tail().head() = " + str2.tail().head())
  }

  def printN[T] (it:Iterator[T],n:Int):Unit = 
    if (it.hasNext) {
      if (n>0) {
	print(" [" + it.next() + "]");
	printN(it,n-1)
      } else 
	println(" ...")
    } else 
      println("")




  def stringLengthIterator (it:Iterator[String]):Iterator[Int] = 
    new StringLengthIterator(it)

  private 
  class StringLengthIterator (it:Iterator[String]) extends Iterator[Int] {
    def hasNext:Boolean = it.hasNext
    def next ():Int = it.next().size
  }
}
