
object BinTree {

  def empty[T] ():BinTree[T] = new Empty[T]()

  def node[T] (n:T, l:BinTree[T], r:BinTree[T]):BinTree[T] = 
    new Node[T](n,l,r)

  private class Empty[T] extends BinTree[T] {
    
    def isEmpty ():Boolean = true

    def root ():T = 
      throw new RuntimeException("BinTree.empty().root()")
    def left ():BinTree[T] = 
      throw new RuntimeException("BinTree.empty().left()")
    def right ():BinTree[T] = 
      throw new RuntimeException("BinTree.empty().right()")

    def size ():Int = 0

    // canonical methods?

    override def toString ():String = "-"

    // stream methods
    def hasElement ():Boolean = false
    def head ():T = 
      throw new RuntimeException("BinTree.empty().head()")
    def tail ():Stream[T] = 
      throw new RuntimeException("BinTree.empty().tail()")

  }

  private class Node[T] (n:T, l:BinTree[T], r:BinTree[T]) extends BinTree[T] {

    def isEmpty ():Boolean = false

    def root ():T = n
    def left ():BinTree[T] = l
    def right ():BinTree[T] = r

    def size ():Int = 1 + l.size() + r.size()

    // canonical methods?

    override def toString ():String = n + "[" + l + "," + r + "]"

    // stream methods
    def hasElement ():Boolean = true

    def head ():T = n
      
    def tail ():Stream[T] = l.sequence(r)
  }
}


abstract class BinTree[T] extends Stream[T] {

  def isEmpty ():Boolean
  def root ():T
  def left ():BinTree[T]
  def right ():BinTree[T]
  def size ():Int

  // from Stream[T]
  def hasElement ():Boolean
  def head ():T
  def tail ():Stream[T]
}


//  trait Iterator[T] { 
//    def hasNext ():Boolean
//    def next ():T
//  }
