object Triangle {

  def create (b:Line, a:Anchor):Triangle = new TriangleRepr(b,a)

  private class TriangleRepr (b:Line, a:Anchor) extends Triangle {

    private var base:Line = b
    private var tip:Anchor = a

    def side1 ():Line = base

    def side2 ():Line = Line.create(base.start(),tip)

    def side3 ():Line = Line.create(base.end(),tip)

    def setBase (l:Line):Unit = { base=l }
    def setTip (a:Anchor):Unit = { tip=a }

    def copy ():Triangle = new TriangleRepr(base,tip)

    def deepCopy ():Triangle = 
      new TriangleRepr(base.deepCopy(),tip.deepCopy())

    override def toString ():String = 
      side1() + "  " + side2() + "  " + side3()
  }
}

abstract class Triangle {

  def side1 ():Line
  def side2 ():Line
  def side3 ():Line
  def setBase (l:Line):Unit
  def setTip (a:Anchor):Unit
  def copy ():Triangle
  def deepCopy ():Triangle
}

