object Line {

  def create (s:Anchor, e:Anchor):Line = new LineRepr(s,e)

  private class LineRepr (initS:Anchor, initE:Anchor) extends Line {

    private var s:Anchor = initS
    private var e:Anchor = initE

    def start ():Anchor = s
    def end ():Anchor = e

    def setStart (a:Anchor):Unit = { s = a }
    def setEnd (a:Anchor):Unit = { e = a }

    def copy ():Line = 
      new LineRepr(s,e)

    def deepCopy ():Line = 
      new LineRepr(s.deepCopy(),e.deepCopy())

    override def toString ():String = s + " <-> " + e
  }
}


abstract class Line {

  def start ():Anchor
  def end ():Anchor
  def setStart (a:Anchor):Unit
  def setEnd (a:Anchor):Unit
  def copy ():Line
  def deepCopy ():Line
}

