object Anchor {

  def create (p:Point):Anchor = new AnchorRepr(p)

  private class AnchorRepr (p:Point) extends Anchor {

    private var pos = p

    def position ():Point = pos
    
    def move (dx:Double, dy:Double):Unit = 
      pos = pos.move(dx,dy)    // move point and reassign 
                               //   pos to be that point

    def copy ():Anchor = 
      new AnchorRepr(pos)

    def deepCopy ():Anchor = 
      new AnchorRepr(pos)

    override def toString ():String = 
      "[" + pos.xCoord() + "," + pos.yCoord() + "]"
  }
}


abstract class Anchor {

  def position ():Point
  def move (dx:Double, dy:Double):Unit 
  def copy ():Anchor
  def deepCopy ():Anchor
}
