
// Parameterized implementation of List ADT
//   with representation classes hidden


object List {

  // creators

  def empty[A] ():List[A] = new ListEmpty[A]()

  def singleton[B] (i:B):List[B] = new ListSingleton[B](i)

  def merge[C] (L:List[C], M:List[C]):List[C] = new ListMerge[C](L,M)


  private class ListEmpty[T] () extends List[T] {

    def isEmpty ():Boolean = true
    def first ():T = throw new RuntimeException("empty().first()")
    def rest ():List[T] = throw new RuntimeException("empty().rest()")

    def length ():Int = 0

    def hasElement ():Boolean = false
    def head ():T = throw new RuntimeException("empty().head()")
    def tail ():Stream[T] = throw new RuntimeException("empty().tail()")

    override def hashCode ():Int = 41
    
    override def toString ():String = ""
  }



  private class ListSingleton[U] (i:U) extends List[U] {
    
    def isEmpty ():Boolean = false
    def first ():U = i
    def rest ():List[U] = List.empty()

    def hasElement ():Boolean = true
    def head ():U = i
    def tail ():Stream[U] = List.empty[U]()    // uses upcasts!

    def length ():Int = 1

    override def hashCode ():Int = 41 + i.hashCode()

    override def toString ():String = " " + i.toString() 
  }


  
  private class ListMerge[V] (L:List[V], M:List[V]) extends List[V] {

    def isEmpty ():Boolean = 
      (L.isEmpty() && M.isEmpty())

    def first ():V = 
      if (L.isEmpty())
        M.first()
      else
        L.first()
    
    def rest ():List[V] = 
      if (L.isEmpty())
        M.rest()
      else
        List.merge(L.rest(),M)

    def length ():Int = L.length() + M.length()

    def hasElement ():Boolean = !(this.isEmpty())
    def head ():V = this.first()
    def tail ():Stream[V] = this.rest()            // uses the intuition that a list
                                                   // is already a finite stream of
                                                   // values
    
    override def hashCode ():Int = 
      41 * (
        41 + L.hashCode()
      ) + M.hashCode()

    override def toString ():String = L.toString() + M.toString()
  }

}


abstract class List[T] extends Stream[T] {

  def isEmpty ():Boolean
  def first ():T
  def rest ():List[T]
  def length ():Int

  // stream operations
  def hasElement ():Boolean
  def head ():T
  def tail ():Stream[T]

}

