
object BinTree {

  def empty[T] ():BinTree[T] = new Empty[T]()

  def node[T] (n:T, l:BinTree[T], r:BinTree[T]):BinTree[T] = 
    new Node[T](n,l,r)



  private class Empty[T] extends BinTree[T] {
    
    def isEmpty ():Boolean = true

    def root ():T = 
      throw new RuntimeException("BinTree.empty().root()")

    def left ():BinTree[T] = 
      throw new RuntimeException("BinTree.empty().left()")

    def right ():BinTree[T] = 
      throw new RuntimeException("BinTree.empty().right()")

    def size ():Int = 0

    def hasElement ():Boolean = false
    def head ():T = throw new RuntimeException("BinTree.empty().head()")
    def tail ():Stream[T] = throw new RuntimeException("BinTree.empty().tail()")

    // canonical methods?

    override def toString ():String = "-"


  }




  private class Node[T] (n:T, l:BinTree[T], r:BinTree[T]) extends BinTree[T] {

    def isEmpty ():Boolean = false

    def root ():T = n

    def left ():BinTree[T] = l

    def right ():BinTree[T] = r

    def size ():Int = 1 + l.size() + r.size()

    def hasElement ():Boolean = true
    def head ():T = n
    def tail ():Stream[T] = Stream.sequence(l,r)


    // canonical methods?

    override def toString ():String = n + "[" + l + "," + r + "]"

  }
}



abstract class BinTree[T] extends Stream[T] {

  def isEmpty ():Boolean
  def root ():T
  def left ():BinTree[T]
  def right ():BinTree[T]
  def size ():Int

  // stream operations
  def hasElement ():Boolean
  def head ():T
  def tail ():Stream[T]
}
