
object Test {


  // def complementCPoint (c:CPoint):Color = 
  //   c.color().complement()
  //
  // def complementCRect (c:CRect):Color = 
  //   c.color().complement()


  def complement[T] (c:Colored[T]):Color =    
    c.color().complement()


  // def makeComplementCPoint (cp:CPoint):CPoint = 
  //   cp.updateColor(complement(cp))
  //
  // def makeComplementCRect (cr:CRect):CRect = 
  //   cr.updateColor(complement(cr))

  def makeComplement[T] (c:Colored[T]):T = 
    c.updateColor(complement(c))


  def moveTwicePoint (p:Point,dx:Double,dy:Double):Point = 
    p.move(dx,dy).move(dx,dy)

  def moveTwiceRect (r:Rect,dx:Double,dy:Double):Rect = 
    r.move(dx,dy).move(dx,dy)

  // IF YOU UNCOMMENT THIS ONE, IT FAILS TO TYPE CHECK
  // Exercise: Figure out WHY???
  //
  //  def moveTwice[T] (s:Shape[T],dx:Double,dy:Double):T  = 
  //  s.move(dx,dy).move(dx,dy)



  def main (argv:Array[String]):Unit = {

    val p1 : Point = Point.cartesian(1.0,2.0)
    val q1 : Point = Point.cartesian(5.0,5.0)
    val r1 : Rect = Rect.create(p1,q1)

    val p2 : Point = Point.cartesian(10.0,20.0)
    val q2 : Point = Point.cartesian(50.0,50.0)
    val r2 : CRect = CRect.create(p2,q2,Color.red())

    val p3 : CPoint = CPoint.cartesian(100.0,200.0,Color.blue())
    
    println("r1 = " + r1)
    println("r2 = " + r2)
    println("p3 = " + p3)
    println("Complement of color of p3 = " + complement(p3))
    println("Complement of color of r2 = " + complement(r2))

    println("Making complement of color of p3 = " + makeComplement[CPoint](p3))
    println("Making complement of color of r2 = " + makeComplement[CRect](r2))

    println("Moving p1 twice = " + moveTwicePoint(p1,1.0,1.0))
    println("Moving r1 twice = " + moveTwiceRect(r1,1.0,1.0))
  }

}
