
object Rect {

  def create (p:Point, q:Point):Rect =
    if (p.xCoord() <= q.xCoord() &&
	p.yCoord() <= q.yCoord())
      new RectImpl(p,q)
    else
      throw new IllegalArgumentException("Rect.create()")


  private class RectImpl (ul:Point, lr:Point) extends Rect {
    def upperLeft ():Point = ul
    
    def lowerRight ():Point = lr

    def move (dx:Double,dy:Double):Rect = 
      new RectImpl(ul.move(dx,dy),
		   lr.move(dx,dy))

    def within (p:Point):Boolean = {
      ul.xCoord() <= p.xCoord() && p.xCoord() <= lr.xCoord() &&
      ul.yCoord() <= p.yCoord() && p.yCoord() <= lr.yCoord()
    }
	
    def isEqual (r:Rect):Boolean = {
      ul==r.upperLeft() && lr==r.lowerRight()
    }

    // CANONICAL 

    override def toString ():String = 
      "rect(" + ul + "," + lr + ")"
    
    override def equals (other : Any):Boolean = 
      other match {
	case that : Rect => this.isEqual(that)
	case _ => false
      }
    
    override def hashCode ():Int = 
      41 * (
	41 + ul.hashCode()
      ) + lr.hashCode()
  }
}



abstract class Rect extends Shape[Rect] {

  def upperLeft ():Point
  def lowerRight ():Point

  def move (dx:Double,dy:Double):Rect
  def within (p:Point):Boolean

  def isEqual (r:Rect):Boolean
}
  
