
object Point {

  def cartesian (x:Double,y:Double):Point =
    new CarPoint(x,y)


  private class CarPoint (first:Double, second:Double) extends Point {
    def xCoord ():Double = 
      first
    
    def yCoord ():Double = 
      second

    def move (dx:Double,dy:Double):Point = 
      cartesian(first+dx,second+dy)

    def rotate (theta:Double):Point = 
      new CarPoint(first * math.cos(theta) - second * math.sin(theta),
                   first * math.sin(theta) + second * math.cos(theta))
    
    def add (p:Point):Point = 
      move(p.xCoord(),p.yCoord())

    def isEqual (q:Point):Boolean = 
      { first==q.xCoord() && second==q.yCoord() }

    // CANONICAL 

    override def toString ():String = 
      "point(" + first + "," + second + ")"
    
    override def equals (other : Any):Boolean = 
      other match {
	case that : Point => this.isEqual(that)
	case _ => false
      }
    
    override def hashCode ():Int = 
      41 * (
	41 + first.hashCode()
      ) + second.hashCode()
  }
}



abstract class Point extends Shape[Point] {

  def xCoord ():Double
  def yCoord ():Double

  def move (dx:Double,dy:Double):Point
  def rotate(t:Double):Point

  def add (p:Point):Point
  def isEqual (p:Point):Boolean
}
  
