
object Color {

  def yellow():Color = new ColorImpl(0)
  def orange():Color = new ColorImpl(1)
  def red():Color = new ColorImpl(2)
  def purple():Color = new ColorImpl(3)
  def blue():Color = new ColorImpl(4)
  def green():Color = new ColorImpl(5)


  private class ColorImpl (color:Int) extends Color {

    private val names : Array[String] = Array("yellow","orange","red",
					      "purple","blue", "green")

    def code ():Int = color

    def complement ():Color = new ColorImpl((color+3) % 6)

    def isEqual (c:Color):Boolean = {
      this.color == c.code()
    }
      
    // CANONICAL METHODS
    
    override def equals (other:Any):Boolean = 
      other match {
	case that : Color => this.isEqual(that)
	case _ => false
      }

    override def hashCode ():Int = 41+color

    override def toString ():String = 
      if (color<0 || color>5)
	"unknown"
      else
	names(color)
  }
}


abstract class Color {

  def code ():Int
  def complement ():Color
  def isEqual (c:Color):Boolean
}
