
object CRect {

  def create (p:Point, q:Point, c:Color):CRect =
    if (p.xCoord() <= q.xCoord() &&
	p.yCoord() <= q.yCoord())
      new CRectImpl(p,q,c)
    else
      throw new IllegalArgumentException("CRect.create()")


  private class CRectImpl (ul:Point, lr:Point, col:Color) extends CRect {
    def color ():Color = col

    def updateColor (c:Color):CRect = 
      new CRectImpl(ul,lr,c)

    def upperLeft ():Point = ul
    def lowerRight ():Point = lr

    def move (dx:Double,dy:Double):CRect = 
      new CRectImpl(ul.move(dx,dy),
		    lr.move(dx,dy), 
		    col)

    def within (p:Point):Boolean = {
      ul.xCoord() <= p.xCoord() && p.xCoord() <= lr.xCoord() &&
      ul.yCoord() <= p.yCoord() && p.yCoord() <= lr.yCoord()
    }
	
    def isEqual (cr:CRect):Boolean = {
      ul==cr.upperLeft() && lr==cr.lowerRight() && color==cr.color()
    }

    def isEqual (r:Rect):Boolean = 
      r match {
	case cr:CRect => this.isEqual(cr)
	case _ => false
      }

    // CANONICAL 

    override def toString ():String = 
      "crect(" + ul + "," + lr + "," + color + ")"
    
    override def equals (other : Any):Boolean = 
      other match {
	case that : CRect => this.isEqual(that)
	case _ => false
      }
    
    override def hashCode ():Int = 
      41 * (
	41 * (
	  41 + ul.hashCode()
	) + lr.hashCode()
      ) + col.hashCode()
  }
}



abstract class CRect extends Rect with Colored[CRect] {  
                 // 'extends' works with classes & traits
                 // 'with' works with traits only
                 // you can only 'extend' one thing

  def color ():Color
  def updateColor (nc:Color):CRect

  def upperLeft ():Point
  def lowerRight ():Point

  def move (dx:Double,dy:Double):CRect
  def within (p:Point):Boolean

  def isEqual (r:CRect):Boolean

  // to get subtyping to work -- a bridge method
  def isEqual (r:Rect):Boolean
}
  
