
object CPoint {

  def cartesian (x:Double,y:Double,c:Color):CPoint =
    new CarCPoint(x,y,c)



  private class CarCPoint (first:Double, second:Double, 
			   col: Color) extends CPoint {

    def color ():Color = col

    def updateColor (c:Color):CPoint = 
      new CarCPoint(first,second,c)

    def xCoord ():Double = 
      first
    
    def yCoord ():Double = 
      second

    def move (dx:Double,dy:Double):CPoint = 
      new CarCPoint(first+dx, second+dy,col)

    def rotate (theta:Double):CPoint = 
      new CarCPoint(first * math.cos(theta) - second * math.sin(theta),
                    first * math.sin(theta) + second * math.cos(theta),
          	    col)

    def add(cp:CPoint):CPoint = 
        new CarCPoint(first+cp.xCoord(),second+cp.yCoord(),cp.color())

    def add (p:Point):Point = 
      p match {
	case cp:CPoint => this.add(cp)
	case _ => Point.cartesian(first+p.xCoord(),second+p.yCoord())
    }

    def isEqual (cp:CPoint):Boolean = {
      first==cp.xCoord() && second==cp.yCoord() && col==cp.color()
    }

    def isEqual (p:Point):Boolean = 
      p match {
	case cp:CPoint => this.isEqual(cp)
	case _ => false
    }

    // CANONICAL

    override def toString ():String = 
      "cpoint(" + first + "," + second + "," + col + ")"
    
    override def equals (other : Any):Boolean = 
      other match {
	case that : CPoint => this.isEqual(that)
	case _ => false
      }
    
    override def hashCode ():Int = 
      41 * (
	41 + first.hashCode()
      ) + second.hashCode()
  }
}



abstract class CPoint extends Point with Colored[CPoint] {

  def color ():Color
  def updateColor (nc:Color):CPoint

  def xCoord ():Double
  def yCoord ():Double

  def move (dx:Double,dy:Double):CPoint
  def rotate(t:Double):CPoint

  def add (cp:CPoint):CPoint
  def isEqual (cp:CPoint):Boolean

  // to get subtyping to work
  def add (p:Point):Point
  def isEqual (p:Point):Boolean
}

