
object Test {

  def sum (x:List):Int = 
    if (x.isEmpty())
      0
    else
      x.first() + sum(x.rest())

  def average (x:List):Int = {
    if (x.isEmpty())
      throw new IllegalArgumentException("Average of empty list")
    else
      (sum(x) / x.length())
  }

  def safeAverage (x:NEList):Int = 
     (sum(x) / x.length())
  

  def main (argv:Array[String]):Unit = {

    val L1:List = 
      List.merge(List.singleton(33),
		 List.merge(List.singleton(66),List.singleton(99)))
    println("L1 = " + L1)
    println("First of L1 = " + L1.first())
    println("Rest of L1 = " + L1.rest())
    println("Length of L1 = " + L1.length())
    println("Sum = " + sum(L1))
    println("Average = " + average(L1))

    val L2:NEList = NEList.merge(NEList.singleton(1),NEList.singleton(10))

    println("L2 = " + L2)
    println("Average = " + average(L2))
    println("Safe average = " + safeAverage(L2))

  }
}
