
// Implementation of NEList ADT
//   with representation classes hidden
//   with auxiliary methods hidden


object NEList {

  // creators

  def singleton (i:Int):NEList = new NEListSingleton(i)

  def merge (L:List, M:NEList):NEList = new NEListMerge(L,M)


  private class NEListSingleton (i:Int) extends NEList {
    
    def isEmpty ():Boolean = false
    def first ():Int = i
    def rest ():List = List.empty()
    def isEqual (L:List):Boolean = 
      (!L.isEmpty() && L.first()==i && L.rest().isEmpty())
    def length ():Int = 1

    override def equals (a:Any):Boolean = a match {
      case that:List => this.isEqual(that)
      case _ => false
    }
    
    override def hashCode ():Int = 41 + i.hashCode()

    override def toString ():String = " " + i.toString() 
  }


  
  private class NEListMerge (L:List, M:NEList) extends NEList {

    def isEmpty ():Boolean = false

    def first ():Int = 
      if (L.isEmpty())
        M.first()
      else
        L.first()

    def rest ():List = 
      if (L.rest().isEmpty())
        M
      else
        NEList.merge(L.rest(),M)

    def isEqual (N:List):Boolean = 
      ((L.isEmpty() && M.isEmpty() && N.isEmpty()) ||
       (!N.isEmpty() && !this.isEmpty() &&
        N.first()==this.first() &&
        N.rest().isEqual(this.rest())))

    def length ():Int = L.length() + M.length()
    
    override def equals (a:Any):Boolean = a match {
      case that:List => this.isEqual(that)
      case _ => false
    }
    
    override def hashCode ():Int = 
      41 * (
        41 + L.hashCode()
      ) + M.hashCode()

    override def toString ():String = L.toString() + M.toString()
  }
}


abstract class NEList extends List {

  def isEmpty ():Boolean
  def first ():Int
  def rest ():List
  def isEqual (L:List):Boolean
  def length ():Int
}

