
// Implementation of List ADT
//   with representation classes hidden


object List {

  // creators

  def empty ():List = new ListEmpty()

  def singleton (i:Int):List = new ListSingleton(i)

  def merge (L:List, M:List):List = new ListMerge(L,M)


  private class ListEmpty () extends List {

    def isEmpty ():Boolean = true
    def first ():Int = throw new RuntimeException("empty().first()")
    def rest ():List = throw new RuntimeException("empty().rest()")
    def isEqual (L:List):Boolean = L.isEmpty()
    def length ():Int = 0
    
    override def equals (a:Any):Boolean = a match {
      case that:List => this.isEqual(that)
      case _ => false
    }

    override def hashCode ():Int = 41
    
    override def toString ():String = ""
  }



  private class ListSingleton (i:Int) extends List {
    
    def isEmpty ():Boolean = false
    def first ():Int = i
    def rest ():List = List.empty()
    def isEqual (L:List):Boolean = 
      (!L.isEmpty() && L.first()==i && L.rest().isEmpty())
    def length ():Int = 1

    override def equals (a:Any):Boolean = a match {
      case that:List => this.isEqual(that)
      case _ => false
    }
    
    override def hashCode ():Int = 41 + i.hashCode()

    override def toString ():String = " " + i.toString() 
  }


  
  private class ListMerge (L:List, M:List) extends List {

    def isEmpty ():Boolean = 
      (L.isEmpty() && M.isEmpty())

    def first ():Int = 
      if (L.isEmpty())
        M.first()
      else
        L.first()
    
    def rest ():List = 
      if (L.isEmpty())
        M.rest()
      else
        List.merge(L.rest(),M)
    
    def isEqual (N:List):Boolean = 
      ((L.isEmpty() && M.isEmpty() && N.isEmpty()) ||
       (!N.isEmpty() && !this.isEmpty() &&
        N.first()==this.first() &&
        N.rest().isEqual(this.rest())))

    def length ():Int = L.length() + M.length()
    
    override def equals (a:Any):Boolean = a match {
      case that:List => this.isEqual(that)
      case _ => false
    }
    
    override def hashCode ():Int = 
      41 * (
        41 + L.hashCode()
      ) + M.hashCode()

    override def toString ():String = L.toString() + M.toString()
  }

}


abstract class List {

  def isEmpty ():Boolean
  def first ():Int
  def rest ():List
  def isEqual (L:List):Boolean
  def length ():Int
}

