
object Point {

  def cartesian (x:Double,y:Double):Point =
     new CarPoint(x,y)

  def polar (r:Double,theta:Double):Point = 
     if (r<0) 
       throw new Error("r negative") 
     else 
       new PolPoint(r,theta)

  private class CarPoint (first:Double, second:Double) extends Point {
    def xCoord ():Double = 
         first
       
    def yCoord ():Double = 
         second

    def angleWithXAxis ():Double = 
         math.atan2(second,first)

    def distanceFromOrigin ():Double = 
         distance(new CarPoint(0,0))

    def distance (q:Point):Double = 
       math.sqrt(math.pow(first - q.xCoord(),2) + 
                 math.pow(second - q.yCoord(),2))

    def move (dx:Double,dy:Double):Point = 
       new CarPoint(first+dx, second+dy)

    def add (q:Point):Point = 
       move(q.xCoord(), q.yCoord())

    def rotate (theta:Double):Point = 
         new CarPoint(first * math.cos(theta) - second * math.sin(theta),
                      first * math.sin(theta) + second * math.cos(theta))


    def isEqual (q:Point):Boolean = 
         first==q.xCoord() && second==q.yCoord()

  override def toString ():String = 
      "cartesian(" + first + "," + second + ")"
    
  override def equals (other : Any):Boolean = 
    other match {
      case that : Point => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 + first.hashCode()
    ) + second.hashCode()
}


  private class PolPoint (first:Double, second:Double) extends Point {

    def xCoord ():Double = 
         first * math.cos(second)
       
    def yCoord ():Double = 
         first * math.sin(second)

    def angleWithXAxis ():Double = 
         second

    def distanceFromOrigin ():Double = 
         first

    def distance (q:Point):Double = 
       math.sqrt(math.pow(xCoord() - q.xCoord(),2) + 
                 math.pow(yCoord() - q.yCoord(),2))

    def move (dx:Double,dy:Double):Point = 
       new CarPoint(xCoord()+dx, yCoord()+dy)

    def add (q:Point):Point = 
       move(q.xCoord(), q.yCoord())

    def rotate (theta:Double):Point = 
         new PolPoint(first, second+theta)

    private def normalize (angle:Double):Double = 
      if (angle >= 2*math.Pi)
        normalize(angle-2*math.Pi)
      else if (angle < 0)
        normalize(angle+2*math.Pi)
      else
        angle

    def isEqual (q:Point):Boolean = 
         first==q.distanceFromOrigin() &&
         normalize(second)==normalize(q.angleWithXAxis())

  override def toString ():String = 
      "polar("+ first + "," + second + ")"
    
  override def equals (other : Any):Boolean = 
    other match {
      case that : Point => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 + first.hashCode()
    ) + second.hashCode()

}


}




abstract class Point {

  def xCoord ():Double
  def yCoord ():Double
  def distanceFromOrigin ():Double
  def angleWithXAxis ():Double


  def move (dx:Double,dy:Double):Point
  def rotate(t:Double):Point

  // def add (q:Point):Point
  // def distance (q:Point):Double
  // def isEqual(q:Point):Boolean
}
