
object CPoint {

  def cartesian (x:Double,y:Double,c:Color):CPoint =
     new CarCPoint(x,y,c)

  def polar (r:Double,theta:Double,c:Color):CPoint = 
     if (r<0) 
       throw new Error("r negative") 
     else 
       new PolCPoint(r,theta,c)
}


class CarCPoint (first:Double, second:Double, col: Color) extends CPoint {

    def color ():Color = col

    def updateColor (c:Color):CPoint = new CarCPoint(first,second,c)

    def xCoord ():Double = 
         first
       
    def yCoord ():Double = 
         second

    def angleWithXAxis ():Double = 
         math.atan2(second,first)

    def distanceFromOrigin ():Double = 
         distance(new CarCPoint(0,0,col))

    def distance (q:CPoint):Double = 
       math.sqrt(math.pow(first - q.xCoord(),2) + 
                 math.pow(second - q.yCoord(),2))

    def move (dx:Double,dy:Double):CPoint = 
       new CarCPoint(first+dx, second+dy,col)

    def add (q:CPoint):CPoint = 
       move(q.xCoord(), q.yCoord())

    def rotate (theta:Double):CPoint = 
         new CarCPoint(first * math.cos(theta) - second * math.sin(theta),
                      first * math.sin(theta) + second * math.cos(theta),
          		      col)


    def isEqual (q:CPoint):Boolean = 
         first==q.xCoord() && second==q.yCoord() && col.isEqual(q.color())

  override def toString ():String = 
      "cartesian(" + first + "," + second + "," + col + ")"
    
  override def equals (other : Any):Boolean = 
    other match {
      case that : CPoint => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 + first.hashCode()
    ) + second.hashCode()
}


class PolCPoint (first:Double, second:Double, col:Color) extends CPoint {

    def color ():Color = col

    def updateColor (c:Color):CPoint = new CarCPoint(first,second,c)

    def xCoord ():Double = 
         first * math.cos(second)
       
    def yCoord ():Double = 
         first * math.sin(second)

    def angleWithXAxis ():Double = 
         second

    def distanceFromOrigin ():Double = 
         first

    def distance (q:CPoint):Double = 
       math.sqrt(math.pow(xCoord() - q.xCoord(),2) + 
                 math.pow(yCoord() - q.yCoord(),2))

    def move (dx:Double,dy:Double):CPoint = 
       new CarCPoint(xCoord()+dx, yCoord()+dy,col)

    def add (q:CPoint):CPoint = 
       move(q.xCoord(), q.yCoord())

    def rotate (theta:Double):CPoint = 
         new PolCPoint(first, second+theta,col)

    private def normalize (angle:Double):Double = 
      if (angle >= 2*math.Pi)
        normalize(angle-2*math.Pi)
      else if (angle < 0)
        normalize(angle+2*math.Pi)
      else
        angle

    def isEqual (q:CPoint):Boolean = 
         first==q.distanceFromOrigin() &&
         normalize(second)==normalize(q.angleWithXAxis()) &&
         col.isEqual(q.color())

  override def toString ():String = 
      "polar("+ first + "," + second + "," + col + ")"
    
  override def equals (other : Any):Boolean = 
    other match {
      case that : CPoint => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 + first.hashCode()
    ) + second.hashCode()

}



abstract class CPoint extends Point {

  def color ():Color
  def updateColor (c:Color):CPoint

  def xCoord ():Double
  def yCoord ():Double
  def distanceFromOrigin ():Double
  def angleWithXAxis ():Double

  def move (dx:Double,dy:Double):CPoint
  def rotate(t:Double):CPoint

//  def distance (q:CPoint):Double
//  def add (q:CPoint):CPoint
//  def isEqual(q:CPoint):Boolean
}
  
