object Point {

  def cartesian (x:Double,y:Double):Point =
     new Point(x,y)

  def polar (r:Double,theta:Double):Point = 
     if (r<0) 
       throw new Error("r negative") 
     else 
       new Point(r*math.cos(theta),r*math.sin(theta))
}

class Point (xpos : Double, ypos : Double) {

  // OPERATIONS

  def xCoord ():Double = xpos

  def yCoord ():Double = ypos

  def distanceFromOrigin ():Double = math.sqrt(xpos*xpos+ypos*ypos)

  def angleWithXAxis ():Double = math.atan2(ypos,xpos)

  def distance (q:Point):Double = math.sqrt(math.pow(xpos-q.xCoord(),2)+
                                            math.pow(ypos-q.yCoord(),2))

  def move (dx:Double, dy:Double):Point = new Point(xpos+dx,ypos+dy)

  def add (q:Point):Point = this.move(q.xCoord(),q.yCoord())

  def rotate (t:Double):Point = 
     new Point(xpos*math.cos(t)-ypos*math.sin(t),
               xpos*math.sin(t)+ypos*math.cos(t))

  def isEqual (q:Point):Boolean = (xpos == q.xCoord()) && 
                                  (ypos == q.yCoord())

  def isOrigin ():Boolean = (xpos == 0) && (ypos == 0)


  // CANONICAL METHODS

  override def equals (other : Any):Boolean = 
    other match {
      case that : Point => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 + xpos.hashCode()
    ) + ypos.hashCode()

  override def toString ():String = 
    "cartesian(" + xpos + "," + ypos + ")"
}
