
object CPoint {
  
  def cartesian(x:Double,y:Double,c:Color):CPoint =
    new CPoint(x,y,c)
  
  def polar(r:Double,theta:Double,c:Color):CPoint = 
    if (r<0) 
      throw new Error("r negative") 
    else 
      new CPoint(r*math.cos(theta),r*math.sin(theta),c)
  
}



class CPoint (xpos : Double, ypos : Double, col:Color) 
  extends Point(xpos,ypos) {

  override def xCoord ():Double = 
    xpos
  
  override def yCoord ():Double = 
    ypos

  def color ():Color = 
    col
  
  override def distanceFromOrigin ():Double = 
    math.sqrt(xpos*xpos+ypos*ypos)

  override def angleWithXAxis ():Double = 
    math.atan2(ypos,xpos)

  def distance (q:CPoint):Double = 
    math.sqrt(math.pow(xpos-q.xCoord(),2)+
              math.pow(ypos-q.yCoord(),2))

  override def move (dx:Double, dy:Double):CPoint = 
    new CPoint(xpos+dx,ypos+dy,col)

  def add (q:CPoint):CPoint = 
    this.move(q.xCoord(),q.yCoord())

  override def rotate (t:Double):CPoint = 
    new CPoint(xpos*math.cos(t)-ypos*math.sin(t),
              xpos*math.sin(t)+ypos*math.cos(t),col)
  
  def isEqual (q:CPoint):Boolean = 
    (xpos == q.xCoord()) && (ypos == q.yCoord()) && (col == q.color())

  override def isOrigin ():Boolean = 
    (xpos == 0) && (ypos == 0)


  // CANONICAL METHODS

  override def equals (other : Any):Boolean = 
    other match {
      case that : CPoint => this.isEqual(that)
      case _ => false
    }
  
  override def hashCode ():Int = 
    41 * (
      41 * (
        41 + xpos.hashCode()
      ) + ypos.hashCode()
    ) + col.hashCode()

  override def toString ():String = 
    "cartesian(" + xpos + "," + ypos + "," + col + ")"
}
